/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.ow2.petals.binding.soap.axis.AbstractAxis2DirBasedObject;
import org.ow2.petals.binding.soap.axis.ServiceConfig;

public class Axis2Repository
extends AbstractAxis2DirBasedObject {
    private final File modulesDir;
    private final File servicesDir;

    public Axis2Repository(File baseDir) {
        super(baseDir);
        this.modulesDir = new File(baseDir, "modules");
        this.servicesDir = new File(baseDir, "services");
    }

    @Override
    public void specificSetUp() {
        this.createDirIfNeeded(this.modulesDir);
        this.createDirIfNeeded(this.servicesDir);
    }

    public void deployService(ServiceConfig serviceConfig) {
        assert (this.isSetUp()) : "Repository must first be set up before deploying a service.";
        File serviceDir = new File(this.servicesDir, serviceConfig.getName());
        assert (!serviceDir.exists()) : String.format("Repository already contains a service called '%s'.", serviceConfig.getName());
        this.createDirIfNeeded(serviceDir);
        File serviceMetaInfDir = new File(serviceDir, "META-INF");
        this.createDirIfNeeded(serviceMetaInfDir);
        File serviceXmlFile = new File(serviceMetaInfDir, "services.xml");
        try {
            FileWriter fw = new FileWriter(serviceXmlFile);
            serviceConfig.dump(fw);
            fw.close();
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }
}

