/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ow2.petals.binding.soap.axis.AbstractNamedConfig;
import org.ow2.petals.binding.soap.axis.OperationConfig;

public class ServiceConfig
extends AbstractNamedConfig {
    private final List<String> transports = new ArrayList<String>();
    private final Map<String, OperationConfig> operations = new LinkedHashMap<String, OperationConfig>();

    public ServiceConfig(String name) {
        super(name);
    }

    public void addTransport(String transport) {
        assert (transport != null);
        this.transports.add(transport);
    }

    @Override
    public void dump(Writer writer) throws IOException {
        writer.write(String.format("<service name='%s'>\n", this.getName()));
        writer.write("  <transports>\n");
        for (String transport : this.transports) {
            writer.write(String.format("  <transport>%s</transport>\n", transport));
        }
        writer.write("  </transports>\n");
        for (OperationConfig operation : this.operations.values()) {
            operation.dump(writer);
        }
        writer.write("</service>\n");
    }

    public void addOperation(OperationConfig operationConfig) {
        assert (operationConfig != null);
        this.operations.put(operationConfig.getName(), operationConfig);
    }
}

