/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.ow2.petals.binding.soap.SoapConsumeFlowStepBeginLogData;
import org.ow2.petals.binding.soap.listener.incoming.SoapExternalListener;
import org.ow2.petals.binding.soap.util.Marshaller;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.LoggingUtil;

public class PetalsReceiver
extends AbstractMessageReceiver {
    private final Logger logger;

    public PetalsReceiver(Logger logger) {
        this.logger = logger;
    }

    private final String retrieveRequestUrl(MessageContext msgContext) {
        String serviceName = msgContext.getServiceContext().getName();
        assert (serviceName != null);
        String operationName = msgContext.getOperationContext().getOperationName();
        assert (operationName != null);
        String transportName = msgContext.getIncomingTransportName();
        assert (transportName != null);
        try {
            EndpointReference epr = msgContext.getConfigurationContext().getListenerManager().getEPRforService(serviceName, operationName, transportName);
            assert (epr != null);
            return epr.getAddress();
        }
        catch (AxisFault e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public final void invokeBusinessLogic(MessageContext msgContext) throws AxisFault {
        try {
            Parameter param = new Parameter("sendStacktraceDetailsWithFaults", (Object)Boolean.TRUE);
            if (msgContext.getAxisOperation() != null) {
                msgContext.getAxisOperation().addParameter(param);
            } else if (msgContext.getAxisService() != null) {
                msgContext.getAxisService().addParameter(param);
            } else if (msgContext.getAxisServiceGroup() != null) {
                msgContext.getAxisServiceGroup().addParameter(param);
            }
            MessageContext outMsgContext = this.process(msgContext);
            if (outMsgContext != null) {
                this.sendBackResponse(outMsgContext);
            }
        }
        catch (AxisFault af) {
            LoggingUtil.addMonitFailureTrace((Logger)this.logger, (FlowAttributes)PetalsExecutionContext.getFlowAttributes(), (String)af.getMessage(), (MessageExchange.Role)MessageExchange.Role.CONSUMER);
            throw af;
        }
    }

    private final void sendBackResponse(MessageContext outMsgContext) throws AxisFault {
        AxisEngine.send((MessageContext)outMsgContext);
    }

    private MessageContext process(MessageContext messageContext) throws AxisFault {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Processing the incoming SOAP message");
        }
        AxisService axisService = messageContext.getAxisService();
        AxisOperation axisOperation = messageContext.getOperationContext().getAxisOperation();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "soapAction found in the incoming message : " + axisOperation.getSoapAction());
        }
        QName jbiOperation = axisOperation.getName();
        int axisMep = axisOperation.getAxisSpecificMEPConstant();
        Message.MEPConstants mep = null;
        if (axisMep == 10) {
            mep = Message.MEPConstants.IN_ONLY_PATTERN;
        } else if (axisMep == 12) {
            mep = Message.MEPConstants.IN_OUT_PATTERN;
        }
        Parameter soapExternalListenerParam = axisService.getParameter("org.ow2.petals.binding.soap.soapExternalListener");
        SoapExternalListener soapExternalListener = (SoapExternalListener)((Object)soapExternalListenerParam.getValue());
        Parameter consumesParam = axisService.getParameter("org.ow2.petals.binding.soap.consumes");
        Consumes consumes = (Consumes)consumesParam.getValue();
        Parameter consumesExtensionsParam = axisService.getParameter("org.ow2.petals.binding.soap.consumesExtensions");
        ConfigurationExtensions consumesExtensions = (ConfigurationExtensions)consumesExtensionsParam.getValue();
        String requestUrl = this.retrieveRequestUrl(messageContext);
        FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
        String flowInstanceId = flowAttributes.getFlowInstanceId();
        String flowStepId = flowAttributes.getFlowStepId();
        this.logger.log(Level.MONIT, "", (Object)new SoapConsumeFlowStepBeginLogData(flowInstanceId, flowStepId, StringHelper.nonNullValue((Object)consumes.getInterfaceName()), StringHelper.nonNullValue((Object)consumes.getServiceName()), consumes.getEndpointName(), StringHelper.nonNullValue((Object)jbiOperation), requestUrl));
        try {
            Exchange exchange = this.createMessageExchange(messageContext, jbiOperation, mep, soapExternalListener, consumes, consumesExtensions);
            SOAPFactory soapFactory = this.getSOAPFactory(messageContext);
            MessageContext responseMessageContext = this.sendJBIMessage(messageContext, soapFactory, exchange, soapExternalListener);
            return responseMessageContext;
        }
        catch (MessagingException me) {
            String errorMsg = "Error while transforming SOAP request to JBI MessageExchange";
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "Error while transforming SOAP request to JBI MessageExchange", me);
            }
            throw new AxisFault("Error while transforming SOAP request to JBI MessageExchange", "Server", (Throwable)me);
        }
        catch (PEtALSCDKException pcdke) {
            String errorMsg = "Error while transforming SOAP request to JBI MessageExchange";
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "Error while transforming SOAP request to JBI MessageExchange", pcdke);
            }
            throw new AxisFault("Error while transforming SOAP request to JBI MessageExchange", "Server", (Throwable)pcdke);
        }
    }

    private final Exchange createMessageExchange(MessageContext inContext, QName operation, Message.MEPConstants mep, SoapExternalListener soapExternalListener, Consumes consumes, ConfigurationExtensions consumesExtensions) throws MessagingException, PEtALSCDKException {
        Exchange msgExchange = mep == null ? soapExternalListener.createConsumeExchange(consumes) : soapExternalListener.createConsumeExchange(consumes, mep);
        msgExchange.setOperation(operation);
        boolean axis1Compatibility = SUPropertiesHelper.isAxis1CompatibilityEnabled(consumesExtensions);
        Source source = inContext.getAttachmentMap() == null || inContext.getAttachmentMap().getContentIDSet() != null && inContext.getAttachmentMap().getContentIDSet().size() <= 0 ? Marshaller.createSourceContent(inContext.getEnvelope(), axis1Compatibility) : Marshaller.createSourceContentAndAttachment(inContext);
        msgExchange.setInMessageContent(source);
        Marshaller.setAttachments(inContext.getAttachmentMap(), msgExchange.getInMessage());
        Marshaller.setProperties(inContext, msgExchange.getInMessage());
        return msgExchange;
    }

    private final void handleResponseAttachments(SOAPFactory soapFactory, NormalizedMessage nm, MessageContext outMessage) throws AxisFault {
        Marshaller.fillSOAPBodyWithAttachments(nm, soapFactory, outMessage);
        SOAPEnvelope env = outMessage.getEnvelope();
        if (env != null && this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "SOAPENVELOPE AFTER Attachment handling");
            this.logger.log(Level.FINE, outMessage.getEnvelope().toString());
        }
    }

    private MessageContext processJBIResponse(Exchange exchange, MessageContext inMessage, SOAPFactory factory, SoapExternalListener soapExternalListener) throws AxisFault {
        if (exchange.getStatus().equals(ExchangeStatus.DONE)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Receive a Done status message");
            }
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            LoggingUtil.addMonitEndOrFailureTrace((Logger)this.logger, (Exchange)exchange, (FlowAttributes)flowAttributes);
            return null;
        }
        if (exchange.getStatus().equals(ExchangeStatus.ERROR)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Receive an Error status message");
            }
            throw new AxisFault("Server", (Throwable)exchange.getError());
        }
        if (exchange.getStatus().equals(ExchangeStatus.ACTIVE)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Receive an Active status message");
            }
            MessageContext outMessage = MessageContextBuilder.createOutMessageContext((MessageContext)inMessage);
            outMessage.getOperationContext().addMessageContext(outMessage);
            try {
                if (exchange.getFault() != null) {
                    SOAPEnvelope envelope = Marshaller.createSOAPEnvelope(factory, (NormalizedMessage)exchange.getFault(), true);
                    outMessage.setEnvelope(envelope);
                } else {
                    NormalizedMessage nm = exchange.getOutMessage();
                    if (nm == null) {
                        String errorMsg = "The MEP '" + exchange.getPattern() + "' does not accept a null response";
                        if (this.logger.isLoggable(Level.WARNING)) {
                            this.logger.log(Level.WARNING, errorMsg);
                        }
                        throw new AxisFault(errorMsg, "Server");
                    }
                    SOAPEnvelope envelope = Marshaller.createSOAPEnvelope(factory, nm, false);
                    outMessage.setEnvelope(envelope);
                    this.handleResponseAttachments(factory, nm, outMessage);
                }
                FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
                LoggingUtil.addMonitEndOrFailureTrace((Logger)this.logger, (Exchange)exchange, (FlowAttributes)flowAttributes);
            }
            catch (MessagingException me) {
                String errorMsg = "Error while creating SOAP response";
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Error while creating SOAP response", me);
                }
                throw new AxisFault("Error while creating SOAP response", "Server", (Throwable)me);
            }
            finally {
                try {
                    exchange.setStatus(ExchangeStatus.DONE);
                    soapExternalListener.send(exchange);
                }
                catch (MessagingException me) {
                    String errorMsg = "Error while closing JBI MessageExchange.";
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "Error while closing JBI MessageExchange.", me);
                    }
                    throw new AxisFault("Error while closing JBI MessageExchange.", "Server", (Throwable)me);
                }
            }
            return outMessage;
        }
        throw new AxisFault("JBI message has wrong status " + exchange.getStatus().toString());
    }

    private MessageContext sendJBIMessage(MessageContext inContext, SOAPFactory factory, Exchange exchange, SoapExternalListener soapExternalListener) throws AxisFault {
        boolean noTimeout = true;
        try {
            noTimeout = soapExternalListener.sendSync(exchange);
        }
        catch (MessagingException e) {
            String errorMsg = "Error while sending JBI exchange with id '" + exchange.getExchangeId() + "'";
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, errorMsg, e);
            }
            throw new AxisFault(errorMsg, "Server", (Throwable)e);
        }
        if (!noTimeout) {
            String errorMsg = "A timeout occurs on JBI exchange with id '" + exchange.getExchangeId() + "'";
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, errorMsg);
            }
            throw new AxisFault(errorMsg, "Server");
        }
        return this.processJBIResponse(exchange, inContext, factory, soapExternalListener);
    }
}

