/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming.servlet;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Server;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.ServerStats;

public class WelcomeServlet
extends HttpServlet {
    private final transient SoapServerConfig config;
    private final transient ServerStats stats;
    private static final String HTML_TITLE = "<html><head><title>Welcome SOAP Binding Component</title></head><body>";
    private static final long serialVersionUID = 1614281322239677571L;

    public WelcomeServlet(SoapServerConfig config, ServerStats stats) {
        this.config = config;
        this.stats = stats;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String redirect = this.config.getRedirect(req.getRequestURI());
        if (redirect != null) {
            if (!redirect.startsWith("/")) {
                redirect = "/" + redirect;
            }
            int pos = redirect.substring(1).indexOf("/");
            String ctxname = redirect.substring(0, pos + 1);
            ServletContext otherContext = this.getServletContext().getContext(ctxname);
            otherContext.getRequestDispatcher(redirect.substring(pos + 1)).forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        ServletOutputStream out = resp.getOutputStream();
        out.write(HTML_TITLE.getBytes());
        out.write("<h1>Petals BC SOAP</h1>".getBytes());
        out.write("<h2>Component Configuration</h2>".getBytes());
        out.write("<ul>".getBytes());
        out.write(("<li>" + this.config.getHostToDisplay() + "</li>").getBytes());
        out.write(("<li>HTTP Port :                " + this.config.getHttpPort() + "</li>").getBytes());
        if (this.config.isHttpsEnabled()) {
            out.write(("<li>HTTPS Port :                " + this.config.getHttpsPort() + "</li>").getBytes());
        }
        out.write(("<li>Jetty Acceptors :     " + this.config.getJettyAcceptors() + "</li>").getBytes());
        out.write(("<li>Jetty Max pool size : " + this.config.getJettyThreadMaxPoolSize() + "</li>").getBytes());
        out.write(("<li>Jetty Min pool size : " + this.config.getJettyThreadMinPoolSize() + "</li>").getBytes());
        out.write(("<li>Services Context :    " + this.config.getServicesContext() + "</li>").getBytes());
        out.write("</ul>".getBytes());
        out.write("<h2>Web Services information</h2>".getBytes());
        out.write("<ul>".getBytes());
        out.write("<li>Services List : ".getBytes());
        String path = "/" + this.config.getServicesContext() + "/" + this.config.getServicesMapping() + "/" + "listServices";
        String link = "<a href='" + path + "'>" + path + "</a>";
        out.write(link.getBytes());
        out.write("</li>".getBytes());
        out.write("</ul>".getBytes());
        out.write("<h2>Server Stats</h2>".getBytes());
        out.write("<ul>".getBytes());
        out.write(("<li>Start time : " + new SimpleDateFormat().format(new Date(this.stats.getStartTime())) + "</li>").getBytes());
        out.write(("<li>Jetty Server version : " + Server.getVersion() + "</li>").getBytes());
        out.write(("<li>Incoming WS GET requests : " + this.stats.getGetRequests() + "</li>").getBytes());
        out.write(("<li>Incoming WS POST requests : " + this.stats.getPostRequests() + "</li>").getBytes());
        out.write("</ul>".getBytes());
        out.write("</body></html>".getBytes());
        out.flush();
        out.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

