/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.ow2.petals.binding.soap.util.StaxUtils;

public class SOAPTestUtil {
    public static final SOAPEnvelope loadSOAPEnvelope(String resourceName, int soapversion) throws Exception {
        Source source = SOAPTestUtil.loadSource(resourceName);
        XMLStreamReader parser = StaxUtils.createXMLStreamReader((Source)source);
        SOAP11Factory factory = null;
        if (soapversion == 11) {
            factory = new SOAP11Factory();
        } else if (soapversion == 12) {
            factory = new SOAP12Factory();
        } else {
            throw new Exception("Unknow version " + soapversion);
        }
        StAXSOAPModelBuilder staxbuilder = OMXMLBuilderFactory.createStAXSOAPModelBuilder((SOAPFactory)factory, (XMLStreamReader)parser);
        return staxbuilder.getSOAPEnvelope();
    }

    private static final Source loadSource(String resourceName) {
        return new StreamSource(SOAPTestUtil.class.getClass().getResourceAsStream(resourceName));
    }
}

