/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.binding.soap.ServiceContext;
import org.ow2.petals.binding.soap.listener.outgoing.PetalsServiceClient;
import org.ow2.petals.binding.soap.listener.outgoing.ServiceClientPoolObjectFactory;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;

public class SoapComponentContext {
    private final ServiceManager<Consumes> consumersManager;
    private final ServiceManager<Provides> providersManager;
    private ConfigurationContext axis2ConfigurationContext;
    private final Map<String, Jbi> jbiDescriptors;
    private final Map<String, File> servicesDescriptors;
    private final Map<ServiceClientKey, ObjectPool> serviceClientPools;
    private final Map<Provides, Set<ServiceClientKey>> providesServiceClientPools;
    private Component componentConfiguration;
    private String jmsJndiInitialFactory;
    private String jmsJndiProviderUrl;
    private String jmsConnectionFactoryName;
    private final Logger logger;

    public SoapComponentContext(ComponentContext context, Component componentConfiguration, Logger logger) {
        assert (componentConfiguration != null);
        assert (componentConfiguration.getProcessorPoolSize() != null);
        assert (componentConfiguration.getAcceptorPoolSize() != null);
        this.logger = logger;
        this.componentConfiguration = componentConfiguration;
        this.jbiDescriptors = new HashMap<String, Jbi>();
        this.servicesDescriptors = new HashMap<String, File>();
        this.consumersManager = new ServiceManager();
        this.providersManager = new ServiceManager();
        this.serviceClientPools = new HashMap<ServiceClientKey, ObjectPool>();
        this.providesServiceClientPools = new HashMap<Provides, Set<ServiceClientKey>>();
    }

    public void addJbiDescriptor(String serviceUnitName, Jbi jbiDescriptor) {
        if (serviceUnitName == null) {
            throw new IllegalArgumentException("Service unit name could not be null");
        }
        this.jbiDescriptors.put(serviceUnitName, jbiDescriptor);
    }

    public void addServiceDescriptor(String serviceUnitName, File serviceDescriptor) {
        if (serviceUnitName == null) {
            throw new IllegalArgumentException("Service unit name could not be null");
        }
        this.servicesDescriptors.put(serviceUnitName, serviceDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PetalsServiceClient borrowServiceClient(String address, QName operation, String soapAction, URI mep, ConfigurationExtensions cdkExtensions, Provides provides) throws MessagingException {
        try {
            String resolvedOp;
            if (operation != null) {
                resolvedOp = operation.toString();
            } else if (soapAction != null) {
                resolvedOp = soapAction;
            } else {
                throw new MessagingException("Unable to resolve the operation. Set it in the Jbi exchange or SoapAction.");
            }
            ServiceClientKey key = new ServiceClientKey(address, resolvedOp, mep);
            ObjectPool pool = this.serviceClientPools.get(key);
            if (pool == null) {
                Long timeout = provides.getTimeout();
                long maxWait = (Message.MEPConstants.IN_OUT_PATTERN.equals(mep) || Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(mep)) && timeout != null ? timeout : 300000L;
                pool = new GenericObjectPool((PoolableObjectFactory)new ServiceClientPoolObjectFactory(address, operation, mep, cdkExtensions, this, provides, this.logger, soapAction), this.componentConfiguration.getProcessorPoolSize().getValue().intValue(), 1, maxWait, this.componentConfiguration.getAcceptorPoolSize().getValue().intValue(), 0, false, false, 300000L, 3, 1800000L, false, -1L, true);
                Map<ServiceClientKey, ObjectPool> map = this.serviceClientPools;
                synchronized (map) {
                    this.serviceClientPools.put(key, pool);
                    Set<ServiceClientKey> serviceClientKeysSet = this.providesServiceClientPools.containsKey(provides) ? this.providesServiceClientPools.get(provides) : new HashSet<ServiceClientKey>();
                    serviceClientKeysSet.add(key);
                    this.providesServiceClientPools.put(provides, serviceClientKeysSet);
                }
            }
            return (PetalsServiceClient)((Object)pool.borrowObject());
        }
        catch (Exception e) {
            throw new MessagingException("Cannot create or get an Axis service client from the pool", (Throwable)e);
        }
    }

    public ConfigurationContext getAxis2ConfigurationContext() {
        return this.axis2ConfigurationContext;
    }

    public ServiceManager<Consumes> getConsumersManager() {
        return this.consumersManager;
    }

    public Jbi getJbiDescriptor(String serviceUnitName) {
        return this.jbiDescriptors.get(serviceUnitName);
    }

    public String getJmsConnectionFactoryName() {
        return this.jmsConnectionFactoryName;
    }

    public String getJmsJndiInitialFactory() {
        return this.jmsJndiInitialFactory;
    }

    public String getJmsJndiProviderUrl() {
        return this.jmsJndiProviderUrl;
    }

    public ServiceManager<Provides> getProvidersManager() {
        return this.providersManager;
    }

    public File getServiceDescriptor(String serviceUnitName) {
        return this.servicesDescriptors.get(serviceUnitName);
    }

    public void removeJbiDescriptor(String serviceUnitName) {
        if (this.jbiDescriptors != null) {
            this.jbiDescriptors.remove(serviceUnitName);
        }
    }

    public void removeServiceDescriptor(String serviceUnitName) {
        this.servicesDescriptors.remove(serviceUnitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServiceClientPools(Provides provides) {
        Map<ServiceClientKey, ObjectPool> map = this.serviceClientPools;
        synchronized (map) {
            Set<ServiceClientKey> serviceClientKeysSet = this.providesServiceClientPools.remove(provides);
            if (serviceClientKeysSet != null) {
                for (ServiceClientKey key : serviceClientKeysSet) {
                    this.serviceClientPools.remove(key);
                }
            }
        }
    }

    public void returnServiceClient(String address, QName operation, URI mep, PetalsServiceClient petalsServiceClient, String soapAction) throws MessagingException {
        try {
            String resolvedOp = null;
            if (operation != null) {
                resolvedOp = operation.toString();
            } else if (soapAction != null) {
                resolvedOp = soapAction;
            } else {
                throw new MessagingException("Unable to resolve the operation. Set it in the Jbi exchange or SoapAction.");
            }
            ObjectPool pool = this.serviceClientPools.get(new ServiceClientKey(address, resolvedOp, mep));
            if (pool != null) {
                pool.returnObject((Object)petalsServiceClient);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Can't return the Axis service client to the pool", (Throwable)e);
        }
    }

    public void setAxis2ConfigurationContext(ConfigurationContext axis2ConfigurationContext) {
        this.axis2ConfigurationContext = axis2ConfigurationContext;
    }

    public void setJmsConnectionFactoryName(String jmsConnectionFactoryName) {
        this.jmsConnectionFactoryName = jmsConnectionFactoryName;
    }

    public void setJmsJndiInitialFactory(String jmsJndiInitialFactory) {
        this.jmsJndiInitialFactory = jmsJndiInitialFactory;
    }

    public void setJmsJndiProviderUrl(String jmsJndiProviderUrl) {
        this.jmsJndiProviderUrl = jmsJndiProviderUrl;
    }

    public static class ServiceManager<E> {
        private final Map<E, ServiceContext<E>> contexts = new HashMap<E, ServiceContext<E>>();

        public void addModules(E e, List<String> modulesList) {
            if (e == null) {
                throw new IllegalArgumentException("Block can not be null");
            }
            ServiceContext<E> serviceContext = this.getServiceContext(e);
            if (serviceContext == null) {
                serviceContext = this.createServiceContext(e);
            }
            serviceContext.setModules(modulesList);
        }

        public ServiceContext<E> createServiceContext(E e) {
            ServiceContext<E> context = new ServiceContext<E>(e);
            this.contexts.put(e, context);
            return context;
        }

        public ServiceContext<E> deleteServiceContext(E e) {
            return this.contexts.remove(e);
        }

        public List<String> getModules(E e) {
            ServiceContext<E> ctx = this.getServiceContext(e);
            if (ctx != null) {
                return ctx.getModules();
            }
            return null;
        }

        public ServiceContext<E> getServiceContext(E e) {
            return this.contexts.get(e);
        }

        public void setClassLoader(E e, ClassLoader classLoader) {
            ServiceContext<E> ctx = this.getServiceContext(e);
            if (ctx == null) {
                ctx = this.createServiceContext(e);
            }
            ctx.setClassloader(classLoader);
        }

        public void addServiceParameters(E e, AxisService axisService) throws XMLStreamException, DeploymentException, AxisFault {
            OMElement parametersElements = this.getServiceParameters(e);
            if (parametersElements != null) {
                Iterator itr = parametersElements.getChildrenWithName(new QName("parameter"));
                while (itr.hasNext()) {
                    OMElement parameterElement = (OMElement)itr.next();
                    if (!"parameter".equalsIgnoreCase(parameterElement.getLocalName())) continue;
                    axisService.addParameter(ServiceManager.getParameter(parameterElement));
                }
            }
        }

        private OMElement getServiceParameters(E e) throws XMLStreamException {
            String serviceParams;
            OMElement serviceParameters = null;
            ServiceContext<E> ctx = this.getServiceContext(e);
            if (ctx != null && (serviceParams = ctx.getServiceParams()) != null) {
                serviceParameters = ServiceManager.buildParametersOM(serviceParams);
            }
            return serviceParameters;
        }

        private static final OMElement buildParametersOM(String parameters) throws XMLStreamException {
            OMElement element = null;
            if (parameters != null && (element = (OMElement)XMLUtils.toOM((Reader)new StringReader(parameters = "<parameters>" + parameters + "</parameters>"))) != null) {
                element.build();
            }
            return element;
        }

        private static Parameter getParameter(OMElement parameterElement) throws DeploymentException {
            Parameter parameter = new Parameter();
            parameter.setParameterElement(parameterElement);
            OMAttribute paramName = parameterElement.getAttribute(new QName("name"));
            if (paramName == null) {
                throw new DeploymentException(Messages.getMessage((String)"badparaagu", (String)parameterElement.toString()));
            }
            parameter.setName(paramName.getAttributeValue());
            OMElement paramValue = parameterElement.getFirstElement();
            if (paramValue != null) {
                parameter.setValue((Object)paramValue);
                parameter.setParameterType(2);
            } else {
                String paratextValue = parameterElement.getText();
                parameter.setValue((Object)paratextValue);
                parameter.setParameterType(1);
            }
            return parameter;
        }
    }

    private static class ServiceClientKey {
        protected final String address;
        protected final String operation;
        protected final URI mep;

        public ServiceClientKey(String address, String operation, URI mep) {
            this.address = address;
            this.operation = operation;
            this.mep = mep;
        }

        public boolean equals(Object obj) {
            boolean bRes = obj instanceof ServiceClientKey ? this.address.equals(((ServiceClientKey)obj).address) && this.operation.equals(((ServiceClientKey)obj).operation) && this.mep.equals(((ServiceClientKey)obj).mep) : false;
            return bRes;
        }

        public int hashCode() {
            return this.address.hashCode() + this.operation.hashCode() + this.mep.hashCode();
        }
    }
}

