/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.TestCase;
import org.ow2.petals.binding.soap.ServiceContext;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.exception.ServiceClientPoolExhaustedException;
import org.ow2.petals.binding.soap.listener.outgoing.PetalsServiceClient;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.jbidescriptor.generated.Runtimepositivestrictint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoapComponentContextTest
extends TestCase {
    private static final Logger LOG = Logger.getLogger(SoapComponentContextTest.class.getName());
    private static final int ACCEPTOR_POOL_SIZE = 1;
    private static final int PROCESSOR_MAX_POOL_SIZE = 5;
    private static final int PROCESSOR_CORE_POOL_SIZE = 2;

    public void testBorrowServiceClient_002() throws MessagingException {
        Component componentCfg = new Component();
        Runtimepositivestrictint acceptorPoolSize = new Runtimepositivestrictint();
        acceptorPoolSize.setValue(1);
        componentCfg.setAcceptorPoolSize(acceptorPoolSize);
        Runtimepositivestrictint processorMaxPoolSize = new Runtimepositivestrictint();
        processorMaxPoolSize.setValue(5);
        componentCfg.setProcessorMaxPoolSize(processorMaxPoolSize);
        Runtimepositivestrictint processorCorePoolSize = new Runtimepositivestrictint();
        processorCorePoolSize.setValue(2);
        componentCfg.setProcessorPoolSize(processorCorePoolSize);
        SoapComponentContext context = new SoapComponentContext(componentCfg, LOG);
        Provides provides = new Provides();
        provides.setEndpointName("MyEndpoint");
        provides.setTimeout(Long.valueOf(1000L));
        ServiceContext serviceCtx = context.getProvidersManager().createServiceContext((Object)provides);
        serviceCtx.setClassloader(Thread.currentThread().getContextClassLoader());
        ArrayList<PetalsServiceClient> serviceClients = new ArrayList<PetalsServiceClient>();
        try {
            for (int i = 0; i < 5; ++i) {
                PetalsServiceClient psc = context.borrowServiceClient("MyAdress", new QName("MyOperation"), "MySoapAction", Message.MEPConstants.IN_OUT_PATTERN.value(), new ConfigurationExtensions(null), provides);
                TestCase.assertNotNull((String)"The web-service client is null", (Object)psc);
                serviceClients.add(psc);
            }
        }
        catch (ServiceClientPoolExhaustedException e) {
            TestCase.fail((String)"The pool of web-service can't be increased to the number of message exchange processors.");
        }
        try {
            context.borrowServiceClient("MyAdress", new QName("MyOperation"), "MySoapAction", Message.MEPConstants.IN_OUT_PATTERN.value(), new ConfigurationExtensions(null), provides);
            TestCase.fail((String)"The pool of web-service is bigger than the message exchange processor.");
        }
        catch (ServiceClientPoolExhaustedException e) {
            // empty catch block
        }
        context.returnServiceClient("MyAdress", new QName("MyOperation"), Message.MEPConstants.IN_OUT_PATTERN.value(), (PetalsServiceClient)serviceClients.remove(0), "MySoapAction");
        try {
            PetalsServiceClient psc = context.borrowServiceClient("MyAdress", new QName("MyOperation"), "MySoapAction", Message.MEPConstants.IN_OUT_PATTERN.value(), new ConfigurationExtensions(null), provides);
            TestCase.assertNotNull((String)"The web-service client is null", (Object)psc);
            serviceClients.add(psc);
        }
        catch (ServiceClientPoolExhaustedException e) {
            TestCase.fail((String)"The pool of web-service is exhausted.");
        }
    }

    public void testGetWsClientMaxPoolSize_000() throws MessagingException {
        int wsClientMaxPoolSize = 23;
        Component componentCfg = new Component();
        Runtimepositivestrictint acceptorPoolSize = new Runtimepositivestrictint();
        acceptorPoolSize.setValue(1);
        componentCfg.setAcceptorPoolSize(acceptorPoolSize);
        Runtimepositivestrictint processorMaxPoolSize = new Runtimepositivestrictint();
        processorMaxPoolSize.setValue(5);
        componentCfg.setProcessorMaxPoolSize(processorMaxPoolSize);
        Runtimepositivestrictint processorCorePoolSize = new Runtimepositivestrictint();
        processorCorePoolSize.setValue(2);
        componentCfg.setProcessorPoolSize(processorCorePoolSize);
        DocumentBuilder docBuilder = DocumentBuilders.takeDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element wsClientPoolSizeMaxElt = doc.createElementNS("http://petals.ow2.org/components/soap/version-4", "ws-clients-pool-size-max");
        wsClientPoolSizeMaxElt.setTextContent(String.valueOf(23));
        componentCfg.getAny().add(wsClientPoolSizeMaxElt);
        SoapComponentContext context = new SoapComponentContext(componentCfg, LOG);
        TestCase.assertEquals((String)"The configured value is not used", (int)23, (int)context.getWsClientMaxPoolSize());
    }

    public void testGetWsClientMaxPoolSize_100() throws MessagingException {
        Component componentCfg = new Component();
        Runtimepositivestrictint acceptorPoolSize = new Runtimepositivestrictint();
        acceptorPoolSize.setValue(1);
        componentCfg.setAcceptorPoolSize(acceptorPoolSize);
        Runtimepositivestrictint processorMaxPoolSize = new Runtimepositivestrictint();
        processorMaxPoolSize.setValue(5);
        componentCfg.setProcessorMaxPoolSize(processorMaxPoolSize);
        Runtimepositivestrictint processorCorePoolSize = new Runtimepositivestrictint();
        processorCorePoolSize.setValue(2);
        componentCfg.setProcessorPoolSize(processorCorePoolSize);
        DocumentBuilder docBuilder = DocumentBuilders.takeDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element wsClientPoolSizeMaxElt = doc.createElementNS("http://petals.ow2.org/components/soap/version-4", "ws-clients-pool-size-max");
        wsClientPoolSizeMaxElt.setTextContent("-15");
        componentCfg.getAny().add(wsClientPoolSizeMaxElt);
        SoapComponentContext context = new SoapComponentContext(componentCfg, LOG);
        TestCase.assertEquals((String)"Default value is not returned", (int)5, (int)context.getWsClientMaxPoolSize());
    }

    public void testGetWsClientMaxPoolSize_101() throws MessagingException {
        Component componentCfg = new Component();
        Runtimepositivestrictint acceptorPoolSize = new Runtimepositivestrictint();
        acceptorPoolSize.setValue(1);
        componentCfg.setAcceptorPoolSize(acceptorPoolSize);
        Runtimepositivestrictint processorMaxPoolSize = new Runtimepositivestrictint();
        processorMaxPoolSize.setValue(5);
        componentCfg.setProcessorMaxPoolSize(processorMaxPoolSize);
        Runtimepositivestrictint processorCorePoolSize = new Runtimepositivestrictint();
        processorCorePoolSize.setValue(2);
        componentCfg.setProcessorPoolSize(processorCorePoolSize);
        DocumentBuilder docBuilder = DocumentBuilders.takeDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element wsClientPoolSizeMaxElt = doc.createElementNS("http://petals.ow2.org/components/soap/version-4", "ws-clients-pool-size-max");
        wsClientPoolSizeMaxElt.setTextContent("0");
        componentCfg.getAny().add(wsClientPoolSizeMaxElt);
        SoapComponentContext context = new SoapComponentContext(componentCfg, LOG);
        TestCase.assertEquals((String)"Default value is not returned", (int)5, (int)context.getWsClientMaxPoolSize());
    }

    public void testGetWsClientMaxPoolSize_102() throws MessagingException {
        Component componentCfg = new Component();
        Runtimepositivestrictint acceptorPoolSize = new Runtimepositivestrictint();
        acceptorPoolSize.setValue(1);
        componentCfg.setAcceptorPoolSize(acceptorPoolSize);
        Runtimepositivestrictint processorMaxPoolSize = new Runtimepositivestrictint();
        processorMaxPoolSize.setValue(5);
        componentCfg.setProcessorMaxPoolSize(processorMaxPoolSize);
        Runtimepositivestrictint processorCorePoolSize = new Runtimepositivestrictint();
        processorCorePoolSize.setValue(2);
        componentCfg.setProcessorPoolSize(processorCorePoolSize);
        DocumentBuilder docBuilder = DocumentBuilders.takeDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element wsClientPoolSizeMaxElt = doc.createElementNS("http://petals.ow2.org/components/soap/version-4", "ws-clients-pool-size-max");
        wsClientPoolSizeMaxElt.setTextContent("abcdef");
        componentCfg.getAny().add(wsClientPoolSizeMaxElt);
        SoapComponentContext context = new SoapComponentContext(componentCfg, LOG);
        TestCase.assertEquals((String)"Default value is not returned", (int)5, (int)context.getWsClientMaxPoolSize());
    }

    public void testGetWsClientMaxPoolSize_103() throws MessagingException {
        Component componentCfg = new Component();
        Runtimepositivestrictint acceptorPoolSize = new Runtimepositivestrictint();
        acceptorPoolSize.setValue(1);
        componentCfg.setAcceptorPoolSize(acceptorPoolSize);
        Runtimepositivestrictint processorMaxPoolSize = new Runtimepositivestrictint();
        processorMaxPoolSize.setValue(5);
        componentCfg.setProcessorMaxPoolSize(processorMaxPoolSize);
        Runtimepositivestrictint processorCorePoolSize = new Runtimepositivestrictint();
        processorCorePoolSize.setValue(2);
        componentCfg.setProcessorPoolSize(processorCorePoolSize);
        DocumentBuilder docBuilder = DocumentBuilders.takeDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element wsClientPoolSizeMaxElt = doc.createElementNS("http://petals.ow2.org/components/soap/version-4", "ws-clients-pool-size-max");
        wsClientPoolSizeMaxElt.setTextContent("");
        componentCfg.getAny().add(wsClientPoolSizeMaxElt);
        SoapComponentContext context = new SoapComponentContext(componentCfg, LOG);
        TestCase.assertEquals((String)"Default value is not returned", (int)5, (int)context.getWsClientMaxPoolSize());
    }
}

