/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.binding.soap.axis.Axis2Repository;

public class Axis2RepositoryTest {
    private static final Set<String> arrayToSet(String[] strings) {
        HashSet<String> result = new HashSet<String>();
        for (String s : strings) {
            result.add(s);
        }
        return result;
    }

    @Test
    public void testSetUp() throws Exception {
        File baseDir = FileSystemHelper.createTempDir();
        Axis2Repository repository = new Axis2Repository(baseDir);
        repository.setUp();
        Assert.assertEquals(Axis2RepositoryTest.arrayToSet(new String[]{"modules", "services"}), Axis2RepositoryTest.arrayToSet(baseDir.list()));
    }

    @Test
    public void testSetUpBaseDirDoesNotExist() throws Exception {
        File baseDir = FileSystemHelper.createTempDir();
        baseDir.delete();
        Axis2Repository repository = new Axis2Repository(baseDir);
        repository.setUp();
        Assert.assertEquals(Axis2RepositoryTest.arrayToSet(new String[]{"modules", "services"}), Axis2RepositoryTest.arrayToSet(baseDir.list()));
    }

    @Test
    public void testSetUpBaseDirModulesAndServicesDirAlreadyExist() throws Exception {
        File baseDir = FileSystemHelper.createTempDir();
        File modulesDir = new File(baseDir, "modules");
        Assert.assertTrue((boolean)modulesDir.mkdir());
        File servicesDir = new File(baseDir, "services");
        Assert.assertTrue((boolean)servicesDir.mkdir());
        Axis2Repository repository = new Axis2Repository(baseDir);
        repository.setUp();
        Assert.assertEquals(Axis2RepositoryTest.arrayToSet(new String[]{"modules", "services"}), Axis2RepositoryTest.arrayToSet(baseDir.list()));
    }
}

