/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.TestHandler;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.ow2.petals.binding.soap.SoapProvideExtFlowStepBeginLogData;
import org.ow2.petals.binding.soap.axis.Axis2Client;
import org.ow2.petals.binding.soap.axis.Axis2TestHelper;
import org.ow2.petals.binding.soap.listener.outgoing.MockWebService;
import org.ow2.petals.commons.PetalsExecutionContext;

public class Axis2ClientTest {
    private static final String TEST_FLOW_INSTANCE_ID = "testFlowInstanceId";
    private static MockWebService mockWebService;
    private static final URL SAMPLE_WSDL_1_URL;
    private static final QName SAMPLE_WSDL_1_SERVICE_NAME;
    private static final String SAMPLE_WSDL_1_PORT_NAME = "Echo";
    private static final String SAMPLE_WSDL_1_SERVICE_URL = "http://localhost:7856/ACTSoap/Echo";
    private static final String SOAP_BODY = "<param0>nimportequoi</param0>";
    private static final String OPERATION_NAME_IN_OUT = "echoString";
    private static final String OPERATION_NAME_IN_ONLY = "echoVoid";
    private static String TEST_PETALS_FILEHANDLER_BASEDIR;

    private static Axis2Client createAxis2Client(URL wsdlUrl, QName wsdlServiceName, String portName, Logger logger) {
        Axis2Client a2c = Axis2TestHelper.createMinimalAxis2Client(wsdlUrl, wsdlServiceName, portName, logger);
        a2c.setUp();
        return a2c;
    }

    private static MockWebService createMockWebService(URL serviceUrl) {
        return new MockSoapWebService(serviceUrl);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_PETALS_FILEHANDLER_BASEDIR = FileSystemHelper.createTempDir((String)"testPetalsFileHandlerBaseDir").getAbsolutePath();
        try {
            mockWebService = Axis2ClientTest.createMockWebService(new URL(SAMPLE_WSDL_1_SERVICE_URL));
            mockWebService.start();
        }
        catch (MalformedURLException mue) {
            throw new UncheckedException((Throwable)mue);
        }
        PetalsExecutionContext.putFlowInstanceId((String)TEST_FLOW_INSTANCE_ID);
        PetalsExecutionContext.putFlowStepId((String)new SimpleUUIDGenerator().getNewID());
        PetalsExecutionContext.putPetalsFileHandlerBaseDir((String)TEST_PETALS_FILEHANDLER_BASEDIR);
    }

    @AfterClass
    public static void afterClass() {
        mockWebService.stop();
        ExecutionContext.getProperties().clear();
        System.clearProperty("petals.home");
    }

    @Test
    public void testLogOnOutgoingRequestMonitDisabledInOutMode() throws Exception {
        TestHandler testHandler = new TestHandler();
        Logger testLogger = Axis2ClientTest.createLoggerWithTestHandler(testHandler);
        Axis2Client a2c = Axis2ClientTest.createAxis2Client(SAMPLE_WSDL_1_URL, SAMPLE_WSDL_1_SERVICE_NAME, SAMPLE_WSDL_1_PORT_NAME, testLogger);
        a2c.submitRequestInOutMep(OPERATION_NAME_IN_OUT, SOAP_BODY);
        List monitRecords = testHandler.getAllRecords(Level.MONIT);
        Assert.assertEquals((long)0L, (long)monitRecords.size());
    }

    @Test
    @Ignore
    public void testLogOnOutgoingRequestWithoutAttachmentMonitEnabledInOutMode() throws Exception {
        TestHandler testHandler = new TestHandler();
        Logger testLogger = Axis2ClientTest.createLoggerWithTestHandler(testHandler);
        testLogger.setLevel(Level.MONIT);
        Axis2Client a2c = Axis2ClientTest.createAxis2Client(SAMPLE_WSDL_1_URL, SAMPLE_WSDL_1_SERVICE_NAME, SAMPLE_WSDL_1_PORT_NAME, testLogger);
        a2c.submitRequestInOutMep(OPERATION_NAME_IN_OUT, SOAP_BODY);
        List monitRecords = testHandler.getAllRecords(Level.MONIT);
        Axis2ClientTest.makeAssertForTestingMonitTraceLevel(monitRecords);
    }

    @Test
    @Ignore
    public void testLogOnOutgoingRequestWithAttachmentsMonitEnabled() throws Exception {
        TestHandler testHandler = new TestHandler();
        Logger testLogger = Axis2ClientTest.createLoggerWithTestHandler(testHandler);
        testLogger.setLevel(Level.MONIT);
        Axis2Client a2c = Axis2ClientTest.createAxis2Client(SAMPLE_WSDL_1_URL, SAMPLE_WSDL_1_SERVICE_NAME, SAMPLE_WSDL_1_PORT_NAME, testLogger);
        String operationName = OPERATION_NAME_IN_OUT;
        String soapBody = "<act:echoStringRequest xmlns:act='http://act.org/'><act:param0 xmlns='http://act.org/'>nimportequoi</act:param0> <act:binaryData></act:binaryData></act:echoStringRequest>";
        a2c.submitRequestWithAttachments(operationName, soapBody, null);
        List monitRecords = testHandler.getAllRecords(Level.MONIT);
        Assert.assertEquals((long)1L, (long)monitRecords.size());
        SoapProvideExtFlowStepBeginLogData soapRequestLogData = Axis2ClientTest.extractOutgoingSoapRequestLogData((LogRecord)monitRecords.get(0));
        SoapProvideExtFlowStepBeginLogData expectedLogData = new SoapProvideExtFlowStepBeginLogData(ExecutionContext.getProperties().getProperty("flowInstanceId"), ExecutionContext.getProperties().getProperty("flowStepId"), SAMPLE_WSDL_1_SERVICE_URL);
        Assert.assertEquals((Object)expectedLogData, (Object)soapRequestLogData);
    }

    @Test
    public void testLogOnOutgoingRequestMonitDisabledInOnlyMode() throws Exception {
        TestHandler testHandler = new TestHandler();
        Logger testLogger = Axis2ClientTest.createLoggerWithTestHandler(testHandler);
        Axis2Client a2c = Axis2ClientTest.createAxis2Client(SAMPLE_WSDL_1_URL, SAMPLE_WSDL_1_SERVICE_NAME, SAMPLE_WSDL_1_PORT_NAME, testLogger);
        a2c.submitRequestInOnlyMep(OPERATION_NAME_IN_ONLY, SOAP_BODY);
        List monitRecords = testHandler.getAllRecords(Level.MONIT);
        Assert.assertEquals((long)0L, (long)monitRecords.size());
    }

    @Test
    @Ignore
    public void testLogOnOutgoingRequestWithoutAttachmentMonitEnabledInOnlyMode() throws Exception {
        TestHandler testHandler = new TestHandler();
        Logger testLogger = Axis2ClientTest.createLoggerWithTestHandler(testHandler);
        testLogger.setLevel(Level.MONIT);
        Axis2Client a2c = Axis2ClientTest.createAxis2Client(SAMPLE_WSDL_1_URL, SAMPLE_WSDL_1_SERVICE_NAME, SAMPLE_WSDL_1_PORT_NAME, testLogger);
        a2c.submitRequestInOnlyMep(OPERATION_NAME_IN_ONLY, SOAP_BODY);
        List monitRecords = testHandler.getAllRecords(Level.MONIT);
        Axis2ClientTest.makeAssertForTestingMonitTraceLevel(monitRecords);
    }

    @Test
    public void testLogOnOutgoingRequestMonitDisabledRobustInOnlyMode() throws Exception {
        TestHandler testHandler = new TestHandler();
        Logger testLogger = Axis2ClientTest.createLoggerWithTestHandler(testHandler);
        Axis2Client a2c = Axis2ClientTest.createAxis2Client(SAMPLE_WSDL_1_URL, SAMPLE_WSDL_1_SERVICE_NAME, SAMPLE_WSDL_1_PORT_NAME, testLogger);
        a2c.submitRequestRobustInOnlyMep(OPERATION_NAME_IN_ONLY, SOAP_BODY);
        List monitRecords = testHandler.getAllRecords(Level.MONIT);
        Assert.assertEquals((long)0L, (long)monitRecords.size());
    }

    @Test
    @Ignore
    public void testLogOnOutgoingRequestWithoutAttachmentMonitEnabledRobustInOnlyMode() throws Exception {
        TestHandler testHandler = new TestHandler();
        Logger testLogger = Axis2ClientTest.createLoggerWithTestHandler(testHandler);
        testLogger.setLevel(Level.MONIT);
        Axis2Client a2c = Axis2ClientTest.createAxis2Client(SAMPLE_WSDL_1_URL, SAMPLE_WSDL_1_SERVICE_NAME, SAMPLE_WSDL_1_PORT_NAME, testLogger);
        a2c.submitRequestRobustInOnlyMep(OPERATION_NAME_IN_ONLY, SOAP_BODY);
        List monitRecords = testHandler.getAllRecords(Level.MONIT);
        Axis2ClientTest.makeAssertForTestingMonitTraceLevel(monitRecords);
    }

    private static final void makeAssertForTestingMonitTraceLevel(List<LogRecord> monitRecords) {
        Assert.assertEquals((long)1L, (long)monitRecords.size());
        SoapProvideExtFlowStepBeginLogData soapRequestLogData = Axis2ClientTest.extractOutgoingSoapRequestLogData(monitRecords.get(0));
        SoapProvideExtFlowStepBeginLogData expectedLogData = new SoapProvideExtFlowStepBeginLogData(ExecutionContext.getProperties().getProperty("flowInstanceId"), ExecutionContext.getProperties().getProperty("flowStepId"), SAMPLE_WSDL_1_SERVICE_URL);
        Assert.assertEquals((Object)expectedLogData, (Object)soapRequestLogData);
    }

    private static final Logger createLoggerWithTestHandler(TestHandler testHandler) {
        Logger logger = Logger.getAnonymousLogger();
        logger.addHandler((Handler)testHandler);
        logger.setLevel(Level.INFO);
        return logger;
    }

    private static final SoapProvideExtFlowStepBeginLogData extractOutgoingSoapRequestLogData(LogRecord logRecord) {
        Assert.assertEquals((long)1L, (long)logRecord.getParameters().length);
        Assert.assertTrue((boolean)(logRecord.getParameters()[0] instanceof SoapProvideExtFlowStepBeginLogData));
        return (SoapProvideExtFlowStepBeginLogData)logRecord.getParameters()[0];
    }

    static {
        SAMPLE_WSDL_1_URL = Axis2ClientTest.class.getClassLoader().getResource("sampleWsdl-1.wsdl");
        SAMPLE_WSDL_1_SERVICE_NAME = new QName("http://act.org/", "EchoService");
    }

    private static class MockSoapWebService
    extends MockWebService {
        private static final String SOAP_RESPONSE = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>  </SOAP-ENV:Body></SOAP-ENV:Envelope>";

        public MockSoapWebService(URL serviceUrl) {
            super(serviceUrl);
        }

        @Override
        public void onPost(HttpServletRequest req, HttpServletResponse resp) {
            ServletOutputStream os = null;
            try {
                os = resp.getOutputStream();
                os.write(SOAP_RESPONSE.getBytes());
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)os);
            }
        }
    }
}

