/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class MockWebService {
    static final String STARTED_MOCK_WEB_SERVICE_LOG_MSG = "Started mock web service on '%s'.";
    static final String STOPPED_MOCK_WEB_SERVICE_LOG_MSG = "Stopped mock web service on '%s'.";
    static final String RECEIVED_GET_REQUEST_LOG_MSG = "Received GET request on '%s'.";
    static final String RECEIVED_POST_REQUEST_LOG_MSG = "Received POST request on '%s'.";
    static final Logger logger = Logger.getLogger(MockWebService.class.getName());
    public static final int HEADER_BUFFER_SIZE = 16384;
    private final URL serviceUrl;
    private final MockWebServiceServlet mockWebServiceServlet;
    private final int port;
    private final String host;
    private final Server server;
    private boolean isStarted;

    public MockWebService(URL serviceUrl) {
        this.serviceUrl = serviceUrl;
        String[] splittedURLParts = serviceUrl.toString().split("/");
        this.port = serviceUrl.getPort();
        this.host = serviceUrl.getHost();
        String servletPath = serviceUrl.toString().replace(serviceUrl.getProtocol() + "://" + serviceUrl.getHost() + ":" + serviceUrl.getPort(), "").replace("/" + splittedURLParts[splittedURLParts.length - 1], "");
        SelectChannelConnector nioConnector = new SelectChannelConnector();
        nioConnector.setPort(this.port);
        nioConnector.setHost(this.host);
        this.server = new Server();
        this.server.setConnectors(new Connector[]{nioConnector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.server.setHandler((Handler)contexts);
        Context mockWebServiceContext = new Context((HandlerContainer)contexts, servletPath, 1);
        this.mockWebServiceServlet = new MockWebServiceServlet();
        ServletHolder mockWebServiceServletHolder = new ServletHolder((Servlet)this.mockWebServiceServlet);
        mockWebServiceServletHolder.setName(splittedURLParts[splittedURLParts.length - 1]);
        mockWebServiceContext.addServlet(mockWebServiceServletHolder, "/");
        this.isStarted = false;
    }

    public final boolean isStarted() {
        return this.isStarted;
    }

    public final void start() {
        if (this.isStarted) {
            return;
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
        logger.info(String.format(STARTED_MOCK_WEB_SERVICE_LOG_MSG, String.valueOf(this.serviceUrl)));
        this.isStarted = true;
    }

    public final void stop() {
        for (Handler h : this.server.getHandlers()) {
            this.server.removeHandler(h);
        }
        for (Handler h : this.server.getChildHandlers()) {
            this.server.removeHandler(h);
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
        logger.info(String.format(STOPPED_MOCK_WEB_SERVICE_LOG_MSG, String.valueOf(this.serviceUrl)));
        this.isStarted = false;
    }

    public void onGet(HttpServletRequest req, HttpServletResponse resp) {
    }

    public void onPost(HttpServletRequest req, HttpServletResponse resp) {
    }

    private class MockWebServiceServlet
    extends HttpServlet {
        private static final long serialVersionUID = 3069362997017015761L;

        private MockWebServiceServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            logger.info(String.format(MockWebService.RECEIVED_GET_REQUEST_LOG_MSG, MockWebService.this.serviceUrl));
            this.mockGet(req, resp);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            logger.info(String.format(MockWebService.RECEIVED_POST_REQUEST_LOG_MSG, MockWebService.this.serviceUrl));
            this.mockPost(req, resp);
        }

        private final void mockGet(HttpServletRequest req, HttpServletResponse resp) {
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Pragma", "no-cache");
            resp.setDateHeader("Expires", 0L);
            resp.setContentType("text/html");
            resp.setStatus(200);
            MockWebService.this.onGet(req, resp);
        }

        private final void mockPost(HttpServletRequest req, HttpServletResponse resp) {
            this.mockGet(req, resp);
            MockWebService.this.onPost(req, resp);
        }
    }
}

