/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming.servlet;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.AxisServlet;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.SOAPHttpTransportListener;
import org.ow2.petals.binding.soap.listener.incoming.jetty.SOAPHttpsTransportListener;
import org.ow2.petals.binding.soap.listener.incoming.jetty.ServerStats;
import org.ow2.petals.binding.soap.util.WsdlHelper;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.LoggingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SoapServlet
extends AxisServlet {
    private final Logger logger;
    private final ConfigurationContext configurationContext;
    private final transient ServerStats stats;
    private final SoapServerConfig config;

    public SoapServlet(Logger logger, ConfigurationContext configurationContext, ServerStats stats, SoapServerConfig config) {
        this.logger = logger;
        this.configurationContext = configurationContext;
        this.stats = stats;
        this.config = config;
    }

    private String createServiceName(HttpServletRequest request) {
        String remove = request.getContextPath() + request.getServletPath() + "/";
        String res = request.getRequestURI().replace(remove, "");
        return res;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        if (this.isImportWSDLRequest(queryString)) {
            this.printImportedDocuments(request, response);
        } else {
            this.stats.newGetRequest();
            super.doGet(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PetalsExecutionContext.initFlowInstanceId();
        PetalsExecutionContext.nextFlowStepId();
        try {
            this.stats.newPostRequest();
            response.addHeader("Connection", "Close");
            super.doPost(request, response);
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "Error when handling a HTTP POST request", t);
            LoggingUtil.addMonitFailureTrace((Logger)this.logger, (FlowAttributes)PetalsExecutionContext.getFlowAttributes(), (String)t.getMessage(), (MessageExchange.Role)MessageExchange.Role.CONSUMER);
        }
    }

    private boolean isImportWSDLRequest(String queryString) {
        return queryString != null && queryString.toLowerCase().startsWith("wsdl");
    }

    private void printImportedDocuments(HttpServletRequest request, HttpServletResponse response) throws AxisFault, IOException, ServletException {
        String transport;
        List exposedTransports;
        AxisService axisService = this.axisConfiguration.getService(this.createServiceName(request));
        if (axisService != null && (exposedTransports = axisService.getExposedTransports()).contains(transport = request.getScheme())) {
            String queryString = request.getQueryString();
            String localServiceAddress = this.config.buildServiceAddress(transport, axisService.getName());
            Parameter componentContextParam = axisService.getParameter("org.ow2.petals.binding.soap.componentContext");
            ComponentContext componentContext = (ComponentContext)componentContextParam.getValue();
            Parameter consumesParam = axisService.getParameter("org.ow2.petals.binding.soap.consumes");
            Consumes consumes = (Consumes)consumesParam.getValue();
            if ("wsdl".equals(queryString)) {
                try {
                    ServletOutputStream out = response.getOutputStream();
                    WsdlHelper.printWSDL(this.logger, consumes, componentContext, (OutputStream)out, localServiceAddress);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    throw new ServletException("Error during streaming serialization", (Throwable)e);
                }
            } else {
                String importsRootURI = localServiceAddress + "?wsdl=";
                Map<URI, Document> importedDocsMap = WsdlHelper.getImportedDocuments(this.logger, consumes, componentContext, importsRootURI);
                boolean find = false;
                for (Map.Entry<URI, Document> entry : importedDocsMap.entrySet()) {
                    if (!entry.getKey().toString().contains(queryString)) continue;
                    find = true;
                    Document importedDoc = entry.getValue();
                    ServletOutputStream out = response.getOutputStream();
                    try {
                        XMLPrettyPrinter.prettify((Node)importedDoc, (OutputStream)out, (String)XMLPrettyPrinter.getEncoding((Document)importedDoc));
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        throw new ServletException("Error on " + queryString + " streaming serialization", (Throwable)e);
                    }
                }
                if (!find) {
                    throw new ServletException("Error: Document unknown: " + queryString + ". Available documents are " + importedDocsMap.keySet().toString());
                }
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        config.getServletContext().setAttribute("CONFIGURATION_CONTEXT", (Object)this.configurationContext);
        super.init(config);
        try {
            this.configureListenerManager();
        }
        catch (AxisFault e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        ListenerManager listenerManager = this.configurationContext.getListenerManager();
        try {
            listenerManager.stop();
            listenerManager.destroy();
        }
        catch (AxisFault e) {
            this.logger.log(Level.WARNING, "Error destroying the ListenerManager.", e);
        }
        super.destroy();
    }

    public void configureListenerManager() throws AxisFault {
        ListenerManager listenerManager = this.configurationContext.getListenerManager();
        TransportInDescription httpTrsIn = new TransportInDescription("http");
        httpTrsIn.setReceiver((TransportListener)new SOAPHttpTransportListener(this.config));
        TransportInDescription httpsTrsIn = new TransportInDescription("https");
        httpsTrsIn.setReceiver((TransportListener)new SOAPHttpsTransportListener(this.config));
        if (listenerManager == null) {
            listenerManager = new ListenerManager();
            listenerManager.init(this.configurationContext);
        }
        listenerManager.addListener(httpTrsIn, true);
        listenerManager.addListener(httpsTrsIn, true);
        listenerManager.setShutdownHookRequired(false);
    }
}

