/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process.async;

import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Settablepositivestrictlong;
import org.ow2.petals.component.framework.process.AbstractMessageManager;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.process.async.AsyncContextCleaner;
import org.ow2.petals.component.framework.process.async.AsyncContextExchange;

public class AsyncMessageManager
extends AbstractMessageManager {
    protected static final int DEFAULT_TIME_BETWEEN_ASYNC_CLEANER_RUNS = 2000;
    public static final String ASYNC_MESSAGE_PROPERTY = "org.ow2.petals.component.framework.asynchronous";
    public static final String ASYNC_EXPIRED_MESSAGE_PROPERTY = "org.ow2.petals.component.framework.asynchronous.expired";
    private final JBIProcessorManager jbiProcessorManager;
    private final ConcurrentMap<String, AsyncContextExchange> asynchronousContexts = new ConcurrentHashMap<String, AsyncContextExchange>();
    private final Timer timer;
    private TimerTask cleanerTask;

    public AsyncMessageManager(AbstractComponent component, JBIProcessorManager jbiProcessorManager, Logger logger) {
        super(component, logger);
        this.jbiProcessorManager = jbiProcessorManager;
        this.timer = new Timer(this.component.getContext().getComponentName() + " - Asynchonous message exchange cleaner");
    }

    public void start() {
        this.cleanerTask = new AsyncContextCleaner(this.asynchronousContexts, this.jbiProcessorManager, this.getRetryMaxTry(), this.getRetryBaseDuration(), this.logger);
        this.timer.schedule(this.cleanerTask, 0L, this.getTimeBeetweenAsyncCleanerRuns());
    }

    public void stop() {
        this.cleanerTask.cancel();
    }

    public void shutdown() {
        this.timer.cancel();
    }

    private final long getTimeBeetweenAsyncCleanerRuns() {
        long timeBeetweenAsyncCleanerRunsValue;
        Settablepositivestrictlong timeBeetweenAsyncCleanerRuns = this.component.getComponentConfiguration().getTimeBeetweenAsyncCleanerRuns();
        if (timeBeetweenAsyncCleanerRuns == null) {
            timeBeetweenAsyncCleanerRunsValue = 2000L;
        } else {
            timeBeetweenAsyncCleanerRunsValue = timeBeetweenAsyncCleanerRuns.getValue();
            if (timeBeetweenAsyncCleanerRunsValue <= 0L) {
                timeBeetweenAsyncCleanerRunsValue = 2000L;
                this.logger.warning("Invalid value for attribute 'time-beetween-async-cleaner-runs': The value must be upper or equals to 1. Default value used (2000).");
            }
        }
        return timeBeetweenAsyncCleanerRunsValue;
    }

    public void referenceAsyncContext(Exchange exchange, AsyncContext asyncContext) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Add AsyncContext for exchange id: " + exchange.getExchangeId());
        }
        exchange.setProperty(ASYNC_MESSAGE_PROPERTY, (Object)Boolean.toString(true));
        asyncContext.setExpirationTime();
        this.asynchronousContexts.put(exchange.getExchangeId(), new AsyncContextExchange(asyncContext, exchange));
    }

    public AsyncContext unreferenceAsyncContext(String exchangeId) {
        AsyncContextExchange asyncContextExchange = (AsyncContextExchange)this.asynchronousContexts.remove(exchangeId);
        if (asyncContextExchange != null) {
            return asyncContextExchange.asyncContext;
        }
        return null;
    }
}

