/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy11.builders;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.SecurityContextToken;

public class SecurityContextTokenBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SecurityContextToken contextToken = new SecurityContextToken(1);
        OMAttribute includeAttr = element.getAttribute(SP11Constants.INCLUDE_TOKEN);
        if (includeAttr != null) {
            int inclusion = SP11Constants.getInclusionFromAttributeValue(includeAttr.getAttributeValue());
            contextToken.setInclusion(inclusion);
        }
        if ((element = element.getFirstChildWithName(SPConstants.POLICY)) != null) {
            if (element.getFirstChildWithName(SP11Constants.REQUIRE_DERIVED_KEYS) != null) {
                contextToken.setDerivedKeys(true);
            }
            if (element.getFirstChildWithName(SP11Constants.REQUIRE_EXTERNAL_URI_REFERNCE) != null) {
                contextToken.setRequireExternalUriRef(true);
            }
            if (element.getFirstChildWithName(SP11Constants.SC10_SECURITY_CONTEXT_TOKEN) != null) {
                contextToken.setSc10SecurityContextToken(true);
            }
        }
        return contextToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SECURITY_CONTEXT_TOKEN};
    }
}

