/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.context.commands.ContextClusteringCommandCollection;
import org.apache.axis2.clustering.context.commands.DeleteServiceGroupContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateConfigurationContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateServiceContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateServiceGroupContextCommand;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.PropertyDifference;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ContextClusteringCommandFactory {
    private static final Log log = LogFactory.getLog(ContextClusteringCommandFactory.class);

    public static ContextClusteringCommandCollection getCommandCollection(AbstractContext[] contexts, Map excludedReplicationPatterns) {
        ArrayList<ContextClusteringCommand> commands = new ArrayList<ContextClusteringCommand>(contexts.length);
        ContextClusteringCommandCollection collection = new ContextClusteringCommandCollection(commands);
        for (AbstractContext context : contexts) {
            ContextClusteringCommand cmd = ContextClusteringCommandFactory.getUpdateCommand(context, excludedReplicationPatterns, false);
            if (cmd == null) continue;
            commands.add(cmd);
        }
        return collection;
    }

    public static ContextClusteringCommand getUpdateCommand(AbstractContext context, Map excludedPropertyPatterns, boolean includeAllProperties) {
        UpdateContextCommand cmd = ContextClusteringCommandFactory.toUpdateContextCommand(context);
        if (cmd != null) {
            ContextClusteringCommandFactory.fillProperties(cmd, context, excludedPropertyPatterns, includeAllProperties);
            if (cmd.isPropertiesEmpty()) {
                cmd = null;
            }
        }
        return cmd;
    }

    public static ContextClusteringCommand getUpdateCommand(AbstractContext context, String[] propertyNames) throws ClusteringFault {
        UpdateContextCommand cmd = ContextClusteringCommandFactory.toUpdateContextCommand(context);
        if (cmd != null) {
            ContextClusteringCommandFactory.fillProperties(cmd, context, propertyNames);
            if (cmd.isPropertiesEmpty()) {
                cmd = null;
            }
        }
        return cmd;
    }

    private static UpdateContextCommand toUpdateContextCommand(AbstractContext context) {
        UpdateContextCommand cmd = null;
        if (context instanceof ConfigurationContext) {
            cmd = new UpdateConfigurationContextCommand();
        } else if (context instanceof ServiceGroupContext) {
            ServiceGroupContext sgCtx = (ServiceGroupContext)context;
            cmd = new UpdateServiceGroupContextCommand();
            UpdateServiceGroupContextCommand updateSgCmd = (UpdateServiceGroupContextCommand)cmd;
            updateSgCmd.setServiceGroupName(sgCtx.getDescription().getServiceGroupName());
            updateSgCmd.setServiceGroupContextId(sgCtx.getId());
        } else if (context instanceof ServiceContext) {
            ServiceContext serviceCtx = (ServiceContext)context;
            cmd = new UpdateServiceContextCommand();
            UpdateServiceContextCommand updateServiceCmd = (UpdateServiceContextCommand)cmd;
            String sgName = serviceCtx.getServiceGroupContext().getDescription().getServiceGroupName();
            updateServiceCmd.setServiceGroupName(sgName);
            updateServiceCmd.setServiceGroupContextId(serviceCtx.getServiceGroupContext().getId());
            updateServiceCmd.setServiceName(serviceCtx.getAxisService().getName());
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillProperties(UpdateContextCommand updateCmd, AbstractContext context, Map excludedPropertyPatterns, boolean includeAllProperties) {
        if (!includeAllProperties) {
            AbstractContext abstractContext = context;
            synchronized (abstractContext) {
                Map<String, Object> diffs = context.getPropertyDifferences();
                for (String o : diffs.keySet()) {
                    String key = o;
                    PropertyDifference diff = (PropertyDifference)diffs.get(key);
                    Object value = diff.getValue();
                    if (!(value instanceof Serializable) || ContextClusteringCommandFactory.isExcluded(key, context.getClass().getName(), excludedPropertyPatterns)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sending property =" + key + "-" + value));
                    }
                    updateCmd.addProperty(diff);
                }
            }
        }
        AbstractContext abstractContext = context;
        synchronized (abstractContext) {
            Iterator<String> iter = context.getPropertyNames();
            while (iter.hasNext()) {
                String key = iter.next();
                Object value = context.getPropertyNonReplicable(key);
                if (!(value instanceof Serializable) || ContextClusteringCommandFactory.isExcluded(key, context.getClass().getName(), excludedPropertyPatterns)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sending property =" + key + "-" + value));
                }
                PropertyDifference diff = new PropertyDifference(key, value, false);
                updateCmd.addProperty(diff);
            }
        }
    }

    private static void fillProperties(UpdateContextCommand updateCmd, AbstractContext context, String[] propertyNames) throws ClusteringFault {
        Map<String, Object> diffs = context.getPropertyDifferences();
        for (String key : propertyNames) {
            Object prop = context.getPropertyNonReplicable(key);
            if (prop instanceof Serializable) {
                PropertyDifference diff;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sending property =" + key + "-" + prop));
                }
                if ((diff = (PropertyDifference)diffs.get(key)) == null) continue;
                diff.setValue(prop);
                updateCmd.addProperty(diff);
                diffs.remove(key);
                continue;
            }
            String msg = "Trying to replicate non-serializable property " + key + " in context " + context;
            throw new ClusteringFault(msg);
        }
    }

    private static boolean isExcluded(String propertyName, String ctxClassName, Map excludedPropertyPatterns) {
        List defaultExcludes;
        List specificExcludes = (List)excludedPropertyPatterns.get(ctxClassName);
        boolean isExcluded = false;
        if (specificExcludes != null) {
            isExcluded = ContextClusteringCommandFactory.isExcluded(specificExcludes, propertyName);
        }
        if (!isExcluded && (defaultExcludes = (List)excludedPropertyPatterns.get("defaults")) != null) {
            isExcluded = ContextClusteringCommandFactory.isExcluded(defaultExcludes, propertyName);
        }
        return isExcluded;
    }

    private static boolean isExcluded(List list, String propertyName) {
        for (Object aList : list) {
            String pattern = (String)aList;
            if (!(pattern.startsWith("*") ? propertyName.endsWith(pattern = pattern.replaceAll("\\*", "")) : (pattern.endsWith("*") ? propertyName.startsWith(pattern = pattern.replaceAll("\\*", "")) : pattern.equals(propertyName)))) continue;
            return true;
        }
        return false;
    }

    public static ContextClusteringCommand getRemoveCommand(AbstractContext abstractContext) {
        if (abstractContext instanceof ServiceGroupContext) {
            ServiceGroupContext sgCtx = (ServiceGroupContext)abstractContext;
            DeleteServiceGroupContextCommand cmd = new DeleteServiceGroupContextCommand();
            cmd.setServiceGroupContextId(sgCtx.getId());
            return cmd;
        }
        return null;
    }
}

