/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.petals.binding.soap.ServiceContext;
import org.ow2.petals.binding.soap.SoapComponent;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.listener.incoming.PetalsReceiver;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.AxisServletServer;
import org.ow2.petals.binding.soap.util.ComponentPropertiesHelper;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.BindingComponentServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.ClassLoaderUtil;
import org.w3c.dom.Document;

public class SoapSUManager
extends BindingComponentServiceUnitManager {
    private ComponentContext componentContext;
    private SoapComponentContext soapContext;
    private SoapComponent soapComponent;
    private Logger logger = null;
    private SoapServerConfig soapServerConfig;
    private PetalsReceiver petalsReceiver;

    public SoapSUManager(AbstractBindingComponent bindingComponent) {
        super(bindingComponent);
        this.soapComponent = (SoapComponent)bindingComponent;
    }

    protected void checkConsume(ConfigurationExtensions extensions) {
        if (SUPropertiesHelper.getServiceName(extensions) == null) {
            if (SUPropertiesHelper.getAddress(extensions) == null) {
                this.logger.warning("The field service-name can't be found into the consumes");
            } else {
                this.logger.info("The field address is deprecated, please use service-name");
            }
        }
    }

    protected void checkProvide(ConfigurationExtensions extensions) {
        if (SUPropertiesHelper.getWSATo(extensions) == null && SUPropertiesHelper.getAddress(extensions) == null && this.logger.isLoggable(Level.INFO)) {
            this.logger.info("The field 'wsa-to' isn't specified into the extensions. We'll search the WS-Addressing into the exchanges.");
        }
    }

    private void cleanServiceContexts(String serviceUnitName, Jbi descriptor) {
        this.soapContext.removeJbiDescriptor(serviceUnitName);
        this.soapContext.removeServiceDescriptor(serviceUnitName);
        List providesList = descriptor.getServices().getProvides();
        ServiceUnitDataHandler suDatahandler = null;
        for (Provides provides : providesList) {
            if (suDatahandler == null) {
                suDatahandler = this.getSUDataHandlerForService(provides);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Cleaning context for " + provides);
            }
            this.soapContext.getProvidersManager().deleteServiceContext(provides);
        }
        List consumesList = descriptor.getServices().getConsumes();
        for (Consumes consumes : consumesList) {
            if (suDatahandler == null) {
                suDatahandler = this.getSUDataHandlerForService(consumes);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Cleaning context for " + consumes);
            }
            this.soapContext.getConsumersManager().deleteServiceContext(consumes);
        }
    }

    private void createAxisService(Consumes consumes, File serviceDescriptor, ConfigurationExtensions extensions) throws PEtALSCDKException {
        String newServiceName = SUPropertiesHelper.getServiceName(extensions);
        if (newServiceName == null) {
            newServiceName = SUPropertiesHelper.getAddress(extensions);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("The deprecated address attribute is used. Service name: " + newServiceName);
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("The service name attribute is used. Service name: " + newServiceName);
        }
        try {
            ConfigurationContext axisConfigContext = this.soapContext.getAxis2ConfigurationContext();
            AxisConfiguration axisConfig = axisConfigContext.getAxisConfiguration();
            if (axisConfig.getService(newServiceName) != null) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "The service '" + newServiceName + "' is already registered in Axis, you cannot register it again");
                }
            } else {
                AxisService axisService = new AxisService(newServiceName);
                Parameter wsdlFoundParam = new Parameter("org.ow2.petals.binding.soap.wsdlFound", (Object)false);
                axisService.addParameter(wsdlFoundParam);
                Parameter consumesConfigParam = new Parameter("org.ow2.petals.binding.soap.consumes", (Object)consumes);
                axisService.addParameter(consumesConfigParam);
                Parameter consumesExtensionsConfigParam = new Parameter("org.ow2.petals.binding.soap.consumesExtensions", (Object)extensions);
                axisService.addParameter(consumesExtensionsConfigParam);
                Parameter componentContextParam = new Parameter("org.ow2.petals.binding.soap.componentContext", (Object)this.componentContext);
                axisService.addParameter(componentContextParam);
                Parameter loggerParam = new Parameter("org.ow2.petals.binding.soap.logger", (Object)this.logger);
                axisService.addParameter(loggerParam);
                Parameter petalsReceiverParam = new Parameter("org.ow2.petals.binding.soap.petalsReceiver", (Object)this.petalsReceiver);
                axisService.addParameter(petalsReceiverParam);
                axisService.setEnableAllTransports(false);
                this.setTransportHttpsToAxisService(axisService, this.component.getComponentExtensions(), extensions);
                this.setTransportHttpToAxisService(axisService, extensions);
                this.setTransportJmsToAxisService(axisService, extensions);
                QName jbiServiceQName = consumes.getServiceName();
                if (jbiServiceQName != null) {
                    axisService.setTargetNamespace(jbiServiceQName.getNamespaceURI());
                }
                axisService.addParameter("disableAddressingForInMessages", (Object)Boolean.TRUE.toString());
                axisService.addParameter(new Parameter("sendStacktraceDetailsWithFaults", (Object)Boolean.TRUE));
                SoapSUManager.setServiceParametersToAxisService(this.logger, this.soapContext, consumes, axisService);
                String suRootPath = this.getSUDataHandlerForConsumes(consumes).getInstallRoot();
                axisService.setClassLoader((ClassLoader)new URLClassLoader(ClassLoaderUtil.getUrls((String)suRootPath), axisService.getClassLoader()));
                axisConfig.addService(axisService);
            }
        }
        catch (AxisFault e) {
            throw new PEtALSCDKException("Can not register Service into Axis context", (Throwable)e);
        }
    }

    private void createServicesContext(String serviceUnitName, String suRootPath, Jbi descriptor) {
        ServiceUnitDataHandler suDatahandler = null;
        List providesList = descriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            if (suDatahandler == null) {
                suDatahandler = this.getSUDataHandlerForService(provides);
            }
            ServiceContext<Provides> context = this.soapContext.getProvidersManager().createServiceContext(provides);
            ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)provides);
            context.setModules(SUPropertiesHelper.getModules(extensions));
            context.setServiceParams(SUPropertiesHelper.getServiceParameters(extensions));
            context.setClassloader(this.getServiceClassloader(suRootPath));
        }
        List consumesList = descriptor.getServices().getConsumes();
        for (Consumes consumes : consumesList) {
            if (suDatahandler == null) {
                suDatahandler = this.getSUDataHandlerForService(consumes);
            }
            ServiceContext<Consumes> context = this.soapContext.getConsumersManager().createServiceContext(consumes);
            ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)consumes);
            context.setModules(SUPropertiesHelper.getModules(extensions));
            context.setServiceParams(SUPropertiesHelper.getServiceParameters(extensions));
            context.setClassloader(this.getServiceClassloader(suRootPath));
        }
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        this.logger.log(Level.FINE, "Deploying a new AxisService for SU " + serviceUnitName);
        this.soapContext.addJbiDescriptor(serviceUnitName, jbiDescriptor);
        this.createServicesContext(serviceUnitName, suRootPath, jbiDescriptor);
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = this.soapContext.getJbiDescriptor(serviceUnitName);
        File serviceDescription = this.soapContext.getServiceDescriptor(serviceUnitName);
        if (descriptor != null) {
            ServiceUnitDataHandler suDatahandler = null;
            List consumesList = descriptor.getServices().getConsumes();
            for (Consumes consumes : consumesList) {
                if (suDatahandler == null) {
                    suDatahandler = this.getSUDataHandlerForService(consumes);
                }
                ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)consumes);
                this.checkConsume(extensions);
                this.createAxisService(consumes, serviceDescription, extensions);
                String redirect = SUPropertiesHelper.getHttpRedirection(extensions);
                if (redirect == null) continue;
                AxisServletServer httpServer = this.soapComponent.getExternalListenerManager().getHttpServer();
                String serviceName = SUPropertiesHelper.getServiceName(extensions);
                if (serviceName == null) {
                    serviceName = SUPropertiesHelper.getAddress(extensions);
                }
                StringTokenizer st = new StringTokenizer(redirect, ",;|");
                while (st.hasMoreTokens()) {
                    httpServer.addRedirect(st.nextToken().trim(), serviceName);
                }
            }
            List providesList = descriptor.getServices().getProvides();
            for (Provides provides : providesList) {
                if (suDatahandler == null) {
                    suDatahandler = this.getSUDataHandlerForService(provides);
                }
                ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)provides);
                this.checkProvide(extensions);
                ServiceContext<Provides> context = this.soapContext.getProvidersManager().getServiceContext(provides);
                ServiceEndpoint srvEp = this.componentContext.getEndpoint(provides.getServiceName(), provides.getEndpointName());
                try {
                    Document doc = this.componentContext.getEndpointDescriptor(srvEp);
                    context.setServiceDescription(WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc));
                }
                catch (JBIException e) {
                    this.logger.warning("No endpoint descriptor found for the service endpoint : " + srvEp);
                }
                catch (WSDL4ComplexWsdlException e) {
                    this.logger.warning("Wsdl reading error" + e.getMessage());
                }
                catch (URISyntaxException e) {
                    this.logger.warning("Wsdl reading error" + e.getMessage());
                }
            }
        }
    }

    protected void doStop(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = this.soapContext.getJbiDescriptor(serviceUnitName);
        if (descriptor != null) {
            List consumesList = descriptor.getServices().getConsumes();
            for (Consumes consumes : consumesList) {
                ServiceUnitDataHandler suDatahandler = this.getSUDataHandlerForService(consumes);
                ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)consumes);
                this.unregisterAxisService(extensions);
                String redirect = extensions.get((Object)"http-services-redirection");
                if (redirect == null) continue;
                StringTokenizer st = new StringTokenizer(redirect, ",;|");
                while (st.hasMoreTokens()) {
                    this.soapComponent.getExternalListenerManager().getHttpServer().removeRedirect(st.nextToken().trim());
                }
            }
            List providesList = descriptor.getServices().getProvides();
            for (Provides provides : providesList) {
                this.soapContext.deleteServiceClientPools(provides);
            }
        }
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = ((ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName)).getDescriptor();
        this.cleanServiceContexts(serviceUnitName, descriptor);
    }

    private URLClassLoader getServiceClassloader(String suRootPath) {
        return ClassLoaderUtil.createClassLoader((String)suRootPath, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    public void init(SoapComponentContext soapContext, ComponentContext componentContext, SoapServerConfig soapServerConfig, PetalsReceiver petalsReceiver, Logger logger) {
        this.soapContext = soapContext;
        this.componentContext = componentContext;
        this.soapServerConfig = soapServerConfig;
        this.petalsReceiver = petalsReceiver;
        this.logger = logger;
    }

    private static final void setServiceParametersToAxisService(Logger logger, SoapComponentContext soapContext, Consumes consumes, AxisService axisService) throws AxisFault {
        block4: {
            try {
                soapContext.getConsumersManager().addServiceParameters(consumes, axisService);
            }
            catch (XMLStreamException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(e.getMessage());
                }
            }
            catch (DeploymentException e) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.warning(e.getMessage());
            }
        }
    }

    private void setTransportHttpsToAxisService(AxisService axisService, ConfigurationExtensions componentExtensions, ConfigurationExtensions suExtensions) {
        if (ComponentPropertiesHelper.isHttpsEnabled(componentExtensions) && SUPropertiesHelper.isHttpsTransportEnabled(suExtensions)) {
            axisService.addExposedTransport("https");
            this.logger.log(Level.INFO, "The Axis2 service '" + axisService.getName() + "' has been registered and is available at '" + this.soapServerConfig.getServiceURL(axisService.getName(), "https") + "'");
        }
    }

    private void setTransportHttpToAxisService(AxisService axisService, ConfigurationExtensions extensions) {
        if (SUPropertiesHelper.isHttpTransportEnabled(extensions)) {
            axisService.addExposedTransport("http");
            this.logger.log(Level.INFO, "The Axis2 service '" + axisService.getName() + "' has been registered and is available at '" + this.soapServerConfig.getServiceURL(axisService.getName(), "http") + "'");
        }
    }

    private void setTransportJmsToAxisService(AxisService axisService, ConfigurationExtensions extensions) throws AxisFault {
        if (SUPropertiesHelper.isJmsTransportEnabled(extensions)) {
            axisService.addParameter(new Parameter("transport.jms.Destination", (Object)axisService.getName()));
            axisService.addExposedTransport("jms");
            this.logger.log(Level.INFO, "The Axis2 service '" + axisService.getName() + "' has been registered and is available through JMS.");
        }
    }

    private void unregisterAxisService(ConfigurationExtensions extensions) throws PEtALSCDKException {
        String serviceName = SUPropertiesHelper.getServiceName(extensions);
        if (serviceName == null) {
            serviceName = SUPropertiesHelper.getAddress(extensions);
        }
        AxisConfiguration axisConfig = this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration();
        this.logger.log(Level.INFO, "Removing Axis service '" + serviceName + "'");
        try {
            AxisService axisService = axisConfig.getService(serviceName);
            if (axisService != null) {
                axisConfig.removeServiceGroup(serviceName);
                axisService.getAxisConfiguration().removeService(serviceName);
            } else {
                this.logger.log(Level.WARNING, "Service '" + serviceName + "' not found, can not be unregistered from Axis2");
            }
        }
        catch (AxisFault e) {
            throw new PEtALSCDKException("Can not remove service from Axis context", (Throwable)e);
        }
    }
}

