/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.HTTPConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.HTTPSConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.HTTPSKeystoreConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.HTTPSTruststoreConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.ServerStats;
import org.ow2.petals.binding.soap.listener.incoming.jetty.ServletServerConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.SoapServletServer;
import org.ow2.petals.binding.soap.listener.incoming.servlet.ListServicesServlet;
import org.ow2.petals.binding.soap.listener.incoming.servlet.SoapServlet;
import org.ow2.petals.binding.soap.listener.incoming.servlet.WelcomeServlet;

public class AxisServletServer {
    private final Logger logger;
    private SoapServletServer server;
    private SoapServerConfig config;
    private ServerStats stats;

    public AxisServletServer(Logger logger, SoapServerConfig config, ConfigurationContext configContext) throws AxisFault {
        this.config = config;
        this.logger = logger;
        this.stats = new ServerStats();
        String restrictedIp = null;
        if (config.isRestricted()) {
            restrictedIp = config.getHostAddress();
        }
        HTTPConfig httpConfig = new HTTPConfig(restrictedIp, config.getHttpPort(), config.getJettyAcceptors());
        HTTPSConfig httpsConfig = null;
        if (config.isHttpsEnabled()) {
            HTTPSTruststoreConfig httpsTruststoreConfig = new HTTPSTruststoreConfig(config.getHttpsTruststoreType(), config.getHttpsTruststoreFile(), config.getHttpsTruststorePassword());
            HTTPSKeystoreConfig httpsKeystoreConfig = new HTTPSKeystoreConfig(config.getHttpsKeystoreKeyPassword(), config.getHttpsKeystorePassword(), config.getHttpsKeystoreFile(), config.getHttpsKeystoreType());
            httpsConfig = new HTTPSConfig(restrictedIp, config.getHttpsPort(), config.getJettyAcceptors(), httpsTruststoreConfig, httpsKeystoreConfig, config.isHttpsClientAuthEnabled());
        }
        ServletServerConfig ssc = new ServletServerConfig(config.getServicesMapping(), config.getServicesContext(), config.getJettyThreadMaxPoolSize(), config.getJettyThreadMinPoolSize(), httpConfig, httpsConfig);
        this.server = new SoapServletServer(ssc, this.createSoapServicesDispatcherServlet(configContext), this.createSoapServicesListingServlet(configContext), this.createWelcomeServlet(), logger);
    }

    private HttpServlet createSoapServicesListingServlet(ConfigurationContext configContext) {
        return new ListServicesServlet(configContext, this.config);
    }

    private HttpServlet createWelcomeServlet() {
        return new WelcomeServlet(this.config, this.stats);
    }

    private HttpServlet createSoapServicesDispatcherServlet(ConfigurationContext configContext) {
        return new SoapServlet(this.logger, configContext, this.stats, this.config);
    }

    public void start() throws AxisFault {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Starting HTTP(S)/SOAP server...");
            this.logger.info(this.config.getHostToDisplay() + " - HTTP Port : " + this.config.getHttpPort() + " - HTTPS Port : " + this.config.getHttpsPort() + " - HTTP(S) server max poolsize : " + this.config.getJettyThreadMaxPoolSize() + " - HTTP(S) server min poolsize : " + this.config.getJettyThreadMinPoolSize() + " - HTTP(S) server acceptors size : " + this.config.getJettyAcceptors());
        }
        try {
            this.stats.setStartTime(System.currentTimeMillis());
            this.server.start();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "Can not start the HTTP(S)/SOAP server");
            }
            throw new AxisFault("Can not start the HTTP(S)/SOAP server", (Throwable)e);
        }
    }

    public void stop() throws AxisFault {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Stopping HTTP(S)/SOAP server...");
        }
        try {
            this.server.stop();
            this.stats.setStopTime(System.currentTimeMillis());
        }
        catch (InterruptedException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public void addRedirect(String from, String to) {
        this.config.addRedirect(from, "/" + this.config.getServicesContext() + "/" + this.config.getServicesMapping() + "/" + to);
    }

    public void removeRedirect(String from) {
        this.config.removeRedirect(from);
    }

    public void addServlet(HttpServlet servlet) {
    }
}

