/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.ow2.petals.binding.soap.listener.incoming.jetty.HTTPConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.HTTPSConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.HTTPSKeystoreConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.HTTPSTruststoreConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.JettyLogger;
import org.ow2.petals.binding.soap.listener.incoming.jetty.JettyNullLogger;
import org.ow2.petals.binding.soap.listener.incoming.jetty.PetalsErrorHandler;
import org.ow2.petals.binding.soap.listener.incoming.jetty.ServletServerConfig;

public class SoapServletServer {
    protected static final String WELCOME_SERVLET_NAME = "WelcomeServlet";
    protected static final String SOAP_SERVICES_LISTING_SERVLET_NAME = "ServicesListServlet";
    protected static final String SOAP_SERVICES_DISPATCHER_SERVLET_NAME = "SoapServlet";
    final Server server;
    private Context soapContext;
    private Context welcomeContext;
    private static final int HEADER_BUFFER_SIZE = 16384;

    public SoapServletServer(ServletServerConfig config, HttpServlet soapServicesDispatcherServlet, HttpServlet soapServicesListingServlet, HttpServlet welcomeServlet, java.util.logging.Logger logger) {
        HTTPSConfig httpsConfig;
        assert (soapServicesDispatcherServlet != null);
        assert (soapServicesListingServlet != null);
        assert (welcomeServlet != null);
        assert (config != null);
        assert (logger != null);
        Log.setLog((Logger)new JettyLogger(logger));
        this.server = new Server();
        HTTPConfig httpConfig = config.getHttpConfig();
        if (httpConfig != null) {
            this.server.addConnector((Connector)this.createNIOHTTPConnector(httpConfig.getHttpPort(), httpConfig.getHttpRestrictedIP(), httpConfig.getAcceptorSize()));
        }
        if ((httpsConfig = config.getHttpsConfig()) != null) {
            SslSelectChannelConnector nioSslConnector = this.createNIOHTTPSConnector(httpsConfig.getHttpsPort(), httpsConfig.getHttpsRestrictedIP(), httpsConfig.getAcceptorSize());
            if (httpsConfig.getHttpsKeystoreConfig() != null) {
                this.initKeyStore(nioSslConnector, httpsConfig.getHttpsKeystoreConfig());
            }
            if (httpsConfig.getHttpsTruststoreConfig() != null) {
                this.initTrustStore(nioSslConnector, httpsConfig.getHttpsTruststoreConfig());
            }
            nioSslConnector.setNeedClientAuth(httpsConfig.isHttpsClientAuthEnabled());
            this.server.addConnector((Connector)nioSslConnector);
        }
        this.server.setThreadPool((ThreadPool)this.createJettyThreadPool(config.getServerMaxPoolSize(), config.getServerMinPoolSize()));
        HandlerCollection handlers = new HandlerCollection();
        this.soapContext = this.createSoapContext(handlers, "/" + config.getServicesContext());
        this.welcomeContext = this.createWelcomeContext(handlers, "/");
        this.deploySoapServicesDispatcherServlet(soapServicesDispatcherServlet, "/" + config.getServicesMapping() + "/*");
        this.deploySoapServicesListingServlet(soapServicesListingServlet, "/" + config.getServicesMapping() + "/" + "listServices");
        this.deployWelcomeServlet(welcomeServlet, "/*");
        this.server.setHandler((Handler)handlers);
    }

    private Context createSoapContext(HandlerCollection handlers, String contextPath) {
        Context soapContext = new Context((HandlerContainer)handlers, contextPath, 1);
        soapContext.setErrorHandler((ErrorHandler)new PetalsErrorHandler(false));
        return soapContext;
    }

    private Context createWelcomeContext(HandlerCollection handlers, String contextPath) {
        Context welcomeContext = new Context((HandlerContainer)handlers, contextPath, 1);
        return welcomeContext;
    }

    private void deploySoapServicesDispatcherServlet(HttpServlet soapServicesDispatcherServlet, String path) {
        ServletHolder soapServletHolder = new ServletHolder((Servlet)soapServicesDispatcherServlet);
        soapServletHolder.setName(SOAP_SERVICES_DISPATCHER_SERVLET_NAME);
        this.soapContext.addServlet(soapServletHolder, path);
    }

    private void deploySoapServicesListingServlet(HttpServlet soapServicesListingServlet, String path) {
        ServletHolder listServicesServletHolder = new ServletHolder((Servlet)soapServicesListingServlet);
        listServicesServletHolder.setName(SOAP_SERVICES_LISTING_SERVLET_NAME);
        this.soapContext.addServlet(listServicesServletHolder, path);
    }

    private void deployWelcomeServlet(HttpServlet welcomeServlet, String path) {
        ServletHolder welcomeServletHolder = new ServletHolder((Servlet)welcomeServlet);
        welcomeServletHolder.setName(WELCOME_SERVLET_NAME);
        this.welcomeContext.addServlet(welcomeServletHolder, path);
    }

    private void initTrustStore(SslSelectChannelConnector nioSslConnector, HTTPSTruststoreConfig httpsTruststoreConfig) {
        String httpsTruststoreFile = httpsTruststoreConfig.getHttpsTruststoreFile();
        String httpsTruststorePassword = httpsTruststoreConfig.getHttpsTruststorePassword();
        String httpsTruststoreType = httpsTruststoreConfig.getHttpsTruststoreType();
        if (httpsTruststoreFile != null && httpsTruststorePassword != null) {
            nioSslConnector.setTruststore(httpsTruststoreFile);
            nioSslConnector.setTrustPassword(httpsTruststorePassword);
            nioSslConnector.setNeedClientAuth(true);
        }
        if (httpsTruststoreType != null) {
            nioSslConnector.setTruststoreType(httpsTruststoreType);
        }
    }

    private SslSelectChannelConnector createNIOHTTPSConnector(int httpsPort, String host, int acceptors) {
        SslSelectChannelConnector nioSslConnector = new SslSelectChannelConnector();
        if (!StringHelper.isNullOrEmpty((String)host)) {
            nioSslConnector.setHost(host);
        }
        nioSslConnector.setPort(httpsPort);
        nioSslConnector.setHeaderBufferSize(16384);
        nioSslConnector.setStatsOn(false);
        nioSslConnector.setAcceptors(acceptors);
        return nioSslConnector;
    }

    private void initKeyStore(SslSelectChannelConnector nioSslConnector, HTTPSKeystoreConfig httpsKeystoreConfig) {
        nioSslConnector.setKeystore(httpsKeystoreConfig.getHttpsKeystoreFile());
        nioSslConnector.setPassword(httpsKeystoreConfig.getHttpsKeystorePassword());
        nioSslConnector.setKeyPassword(httpsKeystoreConfig.getHttpsKeystoreKeyPassword());
        String httpsKeystoreType = httpsKeystoreConfig.getHttpsKeystoreType();
        if (httpsKeystoreType != null) {
            nioSslConnector.setKeystoreType(httpsKeystoreType);
        }
    }

    private SelectChannelConnector createNIOHTTPConnector(int httpPort, String host, int jettyAcceptors) {
        SelectChannelConnector nioConnector = new SelectChannelConnector();
        nioConnector.setPort(httpPort);
        if (!StringHelper.isNullOrEmpty((String)host)) {
            nioConnector.setHost(host);
        }
        nioConnector.setHeaderBufferSize(16384);
        nioConnector.setStatsOn(false);
        nioConnector.setAcceptors(jettyAcceptors);
        return nioConnector;
    }

    private BoundedThreadPool createJettyThreadPool(int threadMaxPoolSize, int threadMinPoolSize) {
        BoundedThreadPool threadPool = new BoundedThreadPool();
        threadPool.setName("BCSoapJettyThreadPool");
        threadPool.setMaxThreads(threadMaxPoolSize);
        threadPool.setMinThreads(threadMinPoolSize);
        return threadPool;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    static {
        System.setProperty("org.mortbay.log.class", JettyNullLogger.class.getName());
        Log.getLog();
    }
}

