/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.logging.Logger;
import org.ow2.petals.binding.soap.SoapComponent;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.listener.outgoing.SOAPCaller;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;

public class JBIListener
extends AbstractJBIListener {
    protected Logger logger;
    private SOAPCaller soapCaller;

    public void init() {
        SoapComponentContext soapContext = ((SoapComponent)this.getComponent()).getSoapContext();
        this.logger = this.getLogger();
        this.soapCaller = new SOAPCaller(soapContext, this.logger);
    }

    public boolean onJBIMessage(Exchange exchange) {
        if (exchange.isActiveStatus()) {
            if (exchange.isProviderRole()) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "JBI message received on SOAP JBI listener");
                }
                ConfigurationExtensions extensions = this.getExtensions();
                this.soapCaller.call(exchange, extensions, this.getProvides());
            } else if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.INFO, "Role not supported in SOAP JBIListener : " + exchange.getRole());
            }
        }
        return true;
    }
}

