/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.ow2.petals.binding.soap.SoapProvideExtFlowStepBeginLogData;
import org.ow2.petals.commons.logger.ProvideExtFlowStepEndLogData;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PetalsServiceClient
extends ServiceClient {
    private Logger logger = null;
    private final HttpClient httpClient;

    public PetalsServiceClient(ConfigurationContext configContext, AxisService axisService, MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager, Provides provides) throws AxisFault {
        super(configContext, axisService);
        this.httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
        this.setTimeOutInMilli(provides);
    }

    public PetalsServiceClient(ConfigurationContext configContext, URL wsdlURL, QName wsdlServiceName, String portName, MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager, Provides provides) throws AxisFault {
        super(configContext, wsdlURL, wsdlServiceName, portName);
        this.httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
        this.setTimeOutInMilli(provides);
    }

    private void setTimeOutInMilli(Provides provides) {
        Long timeout = provides.getTimeout();
        if (timeout != null) {
            this.httpClient.setTimeout(timeout.intValue());
        }
    }

    private void addAdditionalHeadersToEnvelope(SOAPEnvelope envelope, Map<String, DocumentFragment> headers) {
        SOAPHeader soapHeader = envelope.getHeader();
        for (DocumentFragment docfrag : headers.values()) {
            Node node = docfrag.getFirstChild();
            if (!(node instanceof Element)) continue;
            try {
                soapHeader.addChild((OMNode)XMLUtils.toOM((Element)((Element)node)));
            }
            catch (Throwable t) {}
        }
    }

    protected void fillSOAPEnvelope(MessageContext messageContext, OMElement xmlPayload, Map<String, DocumentFragment> headers) throws AxisFault {
        messageContext.setServiceContext(this.getServiceContext());
        SOAPFactory soapFactory = this.getSOAPFactory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        if (xmlPayload != null) {
            envelope.getBody().addChild((OMNode)xmlPayload);
        }
        this.addHeadersToEnvelope(envelope);
        if (headers != null) {
            this.addAdditionalHeadersToEnvelope(envelope, headers);
        }
        messageContext.setEnvelope(envelope);
    }

    protected SOAPFactory getSOAPFactory() {
        String soapVersionURI = this.getOptions().getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }

    public MessageContext sendReceive(QName operationQName, OMElement xmlPayload, Map<String, DocumentFragment> headers) throws AxisFault {
        OperationClient operationClient = this.createOperationClient(operationQName, xmlPayload, headers);
        operationClient.execute(true);
        MessageContext response = operationClient.getMessageContext("In");
        this.logger.log(Level.MONIT, "", new ProvideExtFlowStepEndLogData(ExecutionContext.getProperties().getProperty("flowInstanceId"), ExecutionContext.getProperties().getProperty("flowStepId")));
        return response;
    }

    public void fireAndForget(QName operationQName, OMElement xmlPayload, Map<String, DocumentFragment> headers) throws AxisFault {
        OperationClient operationClient = this.createOperationClient(operationQName, xmlPayload, headers);
        operationClient.execute(false);
    }

    public void sendRobust(QName operationQName, OMElement xmlPayload, Map<String, DocumentFragment> headers) throws AxisFault {
        OperationClient operationClient = this.createOperationClient(operationQName, xmlPayload, headers);
        operationClient.execute(true);
    }

    private OperationClient createOperationClient(QName operationQName, OMElement xmlPayload, Map<String, DocumentFragment> headers) throws AxisFault {
        OperationClient operationClient = this.createClient(operationQName);
        MessageContext messageContext = new MessageContext();
        messageContext.setProperty("CACHED_HTTP_CLIENT", (Object)this.httpClient);
        this.fillSOAPEnvelope(messageContext, xmlPayload, headers);
        operationClient.addMessageContext(messageContext);
        this.logger.log(Level.MONIT, "", (Object)new SoapProvideExtFlowStepBeginLogData(ExecutionContext.getProperties().getProperty("flowInstanceId"), ExecutionContext.getProperties().getProperty("flowStepId"), this.getOptions().getTo().getAddress()));
        return operationClient;
    }

    public final void setLogger(Logger logger) {
        this.logger = logger;
    }
}

