/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.addressing.Addressing;
import org.ow2.petals.binding.soap.addressing.WSAHelper;
import org.ow2.petals.binding.soap.exception.ServiceClientPoolExhaustedException;
import org.ow2.petals.binding.soap.listener.outgoing.PetalsServiceClient;
import org.ow2.petals.binding.soap.util.AttachmentHelper;
import org.ow2.petals.binding.soap.util.Marshaller;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.binding.soap.util.StaxUtils;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class SOAPCaller {
    public SoapComponentContext soapContext;
    public Logger logger;

    public SOAPCaller(SoapComponentContext soapContext, Logger logger) {
        this.soapContext = soapContext;
        this.logger = logger;
    }

    protected static OMElement buildOMElementFromSource(Source body, QName operation, ConfigurationExtensions extensions) throws XMLStreamException {
        StAXOMBuilder builder = null;
        if (body instanceof DOMSource) {
            try {
                builder = new StAXOMBuilder(SourceHelper.convertDOMSource2InputSource((DOMSource)((DOMSource)body)).getByteStream());
            }
            catch (XmlException e) {
                throw new XMLStreamException(e);
            }
        } else {
            XMLStreamReader parser = StaxUtils.createXMLStreamReader(body);
            builder = new StAXOMBuilder(parser);
        }
        OMElement rootElement = builder.getDocumentElement();
        return rootElement;
    }

    protected static OMElement createSOAPBodyContent(NormalizedMessage nm, QName operation, PetalsServiceClient client, ConfigurationExtensions extensions) throws XMLStreamException, UnsupportedEncodingException {
        OMElement document = null;
        Source src = nm.getContent();
        if (src != null) {
            OMFactory fac = OMAbstractFactory.getOMFactory();
            document = SOAPCaller.buildOMElementFromSource(src, operation, extensions);
            if (nm.getAttachmentNames().size() > 0) {
                client.getOptions().setProperty("enableMTOM", (Object)"true");
                Set names = nm.getAttachmentNames();
                for (String key : names) {
                    DataHandler attachment = nm.getAttachment(key);
                    OMElement attachRefElt = AttachmentHelper.hasAttachmentElement(document, attachment, key);
                    if (attachRefElt == null) continue;
                    attachRefElt.getFirstChildWithName(new QName("http://www.w3.org/2004/08/xop/include", "Include")).detach();
                    OMText attach = fac.createOMText((Object)attachment, true);
                    attachRefElt.addChild((OMNode)attach);
                }
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(Exchange exchange, ConfigurationExtensions cdkExtensions, Provides provides) {
        block28: {
            NormalizedMessage in;
            Addressing addressing = this.retrieveAddressing(exchange, cdkExtensions);
            if (addressing.getTo() == null) {
                String message = "Can not define the Web service address to send message to";
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Can not define the Web service address to send message to");
                }
                exchange.setError((Exception)((Object)new MessagingException("BC-SOAP Exception => Can not define the Web service address to send message to")));
                return;
            }
            String address = addressing.getTo();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling external Web Service : " + address);
            }
            if ((in = exchange.getInMessage()) == null) {
                exchange.setError(new Exception("Message exchange must handle an In normalized message"));
            } else {
                QName jbiOperation = exchange.getOperation();
                String soapAction = SUPropertiesHelper.retrieveDefaultSOAPAction(cdkExtensions);
                if (soapAction == null) {
                    soapAction = this.retrieveSoapActionFromWsdl(exchange, provides);
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("jbiOperation of the received exchange: " + jbiOperation);
                    this.logger.fine("soapAction of the received exchange: " + soapAction);
                }
                try {
                    PetalsServiceClient petalsServiceClient = this.soapContext.borrowServiceClient(address, jbiOperation, soapAction, exchange.getExchangePattern(), cdkExtensions, provides);
                    try {
                        petalsServiceClient.setLogger(this.logger);
                        this.updateClient(petalsServiceClient, addressing, exchange);
                        OMElement inBodyElement = SOAPCaller.createSOAPBodyContent(in, exchange.getOperation(), petalsServiceClient, cdkExtensions);
                        if (this.logger.isLoggable(Level.FINE) && inBodyElement != null) {
                            this.logger.log(Level.FINE, "OUTGOING Payload : " + inBodyElement.toString());
                        }
                        if (exchange.isInOnlyPattern()) {
                            petalsServiceClient.fireAndForget(jbiOperation, inBodyElement, this.getHeaders(in, cdkExtensions));
                            break block28;
                        }
                        if (exchange.isRobustInOnlyPattern()) {
                            petalsServiceClient.sendRobust(jbiOperation, inBodyElement, this.getHeaders(in, cdkExtensions));
                            break block28;
                        }
                        if (exchange.isInOptionalOutPattern() || exchange.isInOutPattern()) {
                            MessageContext response = petalsServiceClient.sendReceive(jbiOperation, inBodyElement, this.getHeaders(in, cdkExtensions));
                            if (response.getEnvelope().getBody() != null) {
                                Source source = null;
                                if (response.getAttachmentMap() == null || response.getAttachmentMap().getContentIDSet() != null && response.getAttachmentMap().getContentIDSet().size() <= 0) {
                                    boolean axis1Compatibility = SUPropertiesHelper.isAxis1CompatibilityEnabled(cdkExtensions);
                                    source = Marshaller.createSourceContent(response.getEnvelope(), axis1Compatibility);
                                } else {
                                    source = Marshaller.createSourceContentAndAttachment(response);
                                }
                                NormalizedMessage returnedNormalizedMessage = null;
                                if (response.isFault()) {
                                    this.logger.log(Level.FINE, "RESPONSE is a SOAP Fault.");
                                    returnedNormalizedMessage = exchange.createFault();
                                    exchange.setFault((Fault)returnedNormalizedMessage);
                                } else {
                                    returnedNormalizedMessage = exchange.getOutMessage();
                                }
                                returnedNormalizedMessage.setContent(source);
                                Marshaller.setAttachments(response.getAttachmentMap(), returnedNormalizedMessage);
                                Marshaller.setProperties(response, returnedNormalizedMessage);
                            } else {
                                this.logger.log(Level.FINE, "RESPONSE Payload : No response.");
                            }
                            break block28;
                        }
                        throw new MessagingException("WSCaller - MEP not recognized : " + exchange.getPattern().toString());
                    }
                    finally {
                        this.soapContext.returnServiceClient(address, jbiOperation, exchange.getExchangePattern(), petalsServiceClient, soapAction);
                        if (petalsServiceClient != null && petalsServiceClient.getOptions().isCallTransportCleanup()) {
                            petalsServiceClient.cleanupTransport();
                        }
                    }
                }
                catch (ServiceClientPoolExhaustedException e) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, e.getMessage());
                    }
                    exchange.setError((Exception)((Object)new MessagingException(e.getMessage())));
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "Catch an exception on the WS invocation : " + e.getMessage(), e);
                    }
                    exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)e))));
                }
                catch (Throwable t) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "Catch a throwable on the WS invocation : " + t.getMessage(), t);
                    }
                    exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)new Exception(t)))));
                }
            }
        }
    }

    private Map<String, DocumentFragment> getHeaders(NormalizedMessage nm, ConfigurationExtensions cdkExtensions) {
        HashMap<String, DocumentFragment> result = new HashMap<String, DocumentFragment>();
        List<String> filters = SUPropertiesHelper.retrieveHeaderList(cdkExtensions);
        if (filters != null && filters.size() > 0) {
            HashSet<String> properties = new HashSet<String>();
            Set names = nm.getPropertyNames();
            for (Object object : names) {
                String propertyName;
                if (!(object instanceof String) || !this.isFilteredValue(propertyName = (String)object, filters)) continue;
                properties.add(propertyName);
            }
            for (String propertyName : properties) {
                Object property = nm.getProperty(propertyName);
                if (!(property instanceof DocumentFragment)) continue;
                result.put(propertyName, (DocumentFragment)property);
            }
        }
        if (SUPropertiesHelper.retrieveInjectHeader(cdkExtensions)) {
            List<DocumentFragment> toInject;
            Object protocolHeadersPropertyObject = nm.getProperty("javax.jbi.messaging.protocol.headers");
            if (protocolHeadersPropertyObject != null && protocolHeadersPropertyObject instanceof Map) {
                result.putAll((Map)protocolHeadersPropertyObject);
            }
            if ((toInject = SUPropertiesHelper.retrieveHeaderToInject(cdkExtensions)) != null) {
                int i = 1;
                for (DocumentFragment h : toInject) {
                    result.put("_bc_soap_inject_" + i++, h);
                }
            }
        }
        return result;
    }

    protected boolean isFilteredValue(String propertyName, List<String> filters) {
        boolean result = false;
        for (String filter : filters) {
            String tmp;
            if (propertyName.equalsIgnoreCase(filter)) {
                return true;
            }
            if (!filter.endsWith("*") || !propertyName.equals(tmp = filter.substring(0, filter.lastIndexOf("*"))) && !propertyName.startsWith(tmp)) continue;
            return true;
        }
        return false;
    }

    private final Addressing retrieveAddressing(Exchange exchange, ConfigurationExtensions extensions) {
        Addressing wsAddressing = null;
        try {
            String address;
            Object object;
            if (exchange.getInMessageProperty("com.ebmwebsourcing.wsstar.addressing") != null && (object = exchange.getInMessageProperty("com.ebmwebsourcing.wsstar.addressing")) instanceof Document && (address = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType((Document)object).getAddress()) != null) {
                wsAddressing = WSAHelper.getAddressing(address);
            }
        }
        catch (MessagingException e) {
        }
        catch (WSAddressingException e) {
            // empty catch block
        }
        Addressing suAddressing = WSAHelper.getAddressing(extensions);
        return WSAHelper.merge(wsAddressing, suAddressing);
    }

    private String retrieveSoapActionFromWsdl(Exchange exchange, Provides provides) {
        String soapAction = null;
        try {
            BindingOperation bo;
            Binding b;
            String endpointName = exchange.getEndpointName();
            QName service = exchange.getEndpoint().getServiceName();
            Description d = this.soapContext.getProvidersManager().getServiceContext(provides).getServiceDescription();
            Endpoint e = (Endpoint)((Service)d.getService(service)).getEndpoint(endpointName);
            if (e != null && (b = (Binding)e.getBinding()) != null && (bo = (BindingOperation)b.getBindingOperation(exchange.getOperationName())) != null) {
                soapAction = bo.getSoapAction();
            }
        }
        catch (MessagingException e1) {
            e1.printStackTrace();
            this.logger.warning("Error '" + e1.getMessage() + "' While trying to get elements to resolve soapAction.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.warning("Error '" + e.getMessage() + "' while trying to get elements to resolve soapAction.");
        }
        return soapAction;
    }

    protected void updateClient(PetalsServiceClient client, Addressing addressing, Exchange exchange) {
        if (addressing == null) {
            return;
        }
        Options options = client.getOptions();
        if (addressing.getFaultTo() != null) {
            options.setFaultTo(new EndpointReference(addressing.getFaultTo()));
        }
        if (addressing.getFrom() != null) {
            options.setFrom(new EndpointReference(addressing.getFrom()));
        }
        if (addressing.getReplyTo() != null) {
            options.setReplyTo(new EndpointReference(addressing.getReplyTo()));
        }
    }
}

