/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sql.listener;

import com.ebmwebsourcing.easycommons.logger.Level;
import java.io.IOException;
import java.io.PipedInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.bc.sql.DataSources;
import org.ow2.petals.bc.sql.SqlComponent;
import org.ow2.petals.bc.sql.listener.OutStreamer;
import org.ow2.petals.bc.sql.service.SQLParameter;
import org.ow2.petals.bc.sql.service.SQLService;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JBIListener
extends AbstractJBIListener {
    private DataSources dataSources;
    private SQLService sqlService;
    private ExecutorService threadPool;

    public void init() {
        this.dataSources = ((SqlComponent)this.getComponent()).getDataSources();
        this.sqlService = ((SqlComponent)this.getComponent()).getSQLService();
        this.threadPool = ((SqlComponent)this.getComponent()).getThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onJBIMessage(Exchange exchange) {
        Connection connection = null;
        if (exchange.isActiveStatus()) {
            try {
                if (!JBIListener.validateExchange(exchange)) {
                    this.getLogger().log(Level.WARNING, exchange.getError().getMessage());
                    boolean bl = true;
                    return bl;
                }
                String operation = exchange.getOperationName().toLowerCase();
                PetalsExecutionContext.putFlowStepOperationName((QName)exchange.getOperation());
                String sql = null;
                List<SQLParameter> sqlParameters = null;
                if ("storedprocedure".equals(operation) || "xmlstoredprocedure".equals(operation)) {
                    sqlParameters = JBIListener.getStoredProcedureParams(exchange, this.getExtensions(), this.getLogger());
                } else {
                    sql = JBIListener.getSQLRequest(exchange);
                }
                if (exchange.getError() != null) {
                    this.getLogger().log(Level.WARNING, exchange.getError().getMessage());
                    boolean bl = true;
                    return bl;
                }
                DataSource dataSource = this.dataSources.getDataSource(this.getProvides());
                if (dataSource == null) {
                    throw new MessagingException("No dataSource has been found for the service " + exchange.getService());
                }
                this.getLogger().finest("Get a JDBC connection from the DataSource");
                connection = dataSource.getConnection();
                if ("storedprocedure".equals(operation)) {
                    String storedStatementCall = this.getExtensions().get((Object)"storedProcedureCall");
                    this.sqlService.storedProcedure(sqlParameters, storedStatementCall, connection);
                    OutStreamer outStreamer = new OutStreamer(this.sqlService, sqlParameters, connection, this.getLogger(), false);
                    this.threadPool.execute(outStreamer);
                    PipedInputStream inputStream = outStreamer.getPipedInputStream();
                    exchange.setOutMessageContent((Source)new StreamSource(inputStream));
                    connection = null;
                } else if ("xmlstoredprocedure".equals(operation)) {
                    String storedStatementCall = this.getExtensions().get((Object)"storedProcedureCall");
                    this.sqlService.storedProcedure(sqlParameters, storedStatementCall, connection);
                    OutStreamer outStreamer = new OutStreamer(this.sqlService, sqlParameters, connection, this.getLogger(), true);
                    this.threadPool.execute(outStreamer);
                    PipedInputStream inputStream = outStreamer.getPipedInputStream();
                    exchange.setOutMessageContent((Source)new StreamSource(inputStream));
                    connection = null;
                } else if ("select".equals(operation)) {
                    ResultSet resultSet = this.sqlService.select(sql, connection);
                    boolean showMetadata = this.getShowMetadata(exchange);
                    if (showMetadata) {
                        this.getLogger().finest("Metadata written in the response");
                    }
                    OutStreamer outStreamer = new OutStreamer(this.sqlService, resultSet, showMetadata, connection, this.getLogger());
                    this.threadPool.execute(outStreamer);
                    PipedInputStream inputStream = outStreamer.getPipedInputStream();
                    exchange.setOutMessageContent((Source)new StreamSource(inputStream));
                    connection = null;
                } else if ("insert".equals(operation) || "update".equals(operation) || "delete".equals(operation)) {
                    this.sqlService.update(sql, connection);
                } else {
                    int result = this.sqlService.update(sql, connection);
                    String resultXML = "<updated xmlns=\"http://petals.ow2.org/components/sql/version-1\">" + result + "</updated>";
                    exchange.getOutMessage().setContent(SourceUtil.createSource((String)resultXML));
                }
            }
            catch (MessagingException e) {
                this.getLogger().log(Level.WARNING, e.getMessage(), e);
                exchange.setError((Exception)((Object)e));
            }
            catch (PEtALSCDKException e) {
                this.getLogger().log(Level.WARNING, e.getMessage(), e);
                exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, e.getMessage(), e);
                exchange.setError((Exception)e);
            }
            catch (SQLException e) {
                this.getLogger().log(Level.WARNING, e.getMessage(), e);
                if (e.getClass().getName().startsWith("java.sql")) {
                    exchange.setError((Exception)e);
                } else {
                    exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)e))));
                }
            }
            catch (ParseException e) {
                this.getLogger().log(Level.WARNING, e.getMessage(), e);
                exchange.setError((Exception)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        }
        return true;
    }

    private static final String getSQLRequest(Exchange exchange) throws MessagingException {
        String sql = null;
        Element queryElement = exchange.getInMessageContentAsDocument().getDocumentElement();
        if (!"sql".equals(queryElement.getLocalName()) || !"http://petals.ow2.org/components/sql/version-1".equals(queryElement.getNamespaceURI())) {
            exchange.setError((Exception)((Object)new MessagingException("The request message must contain a root element named 'sql' in the namespace 'http://petals.ow2.org/components/sql/version-1'")));
        } else {
            sql = XMLUtil.getTextContent((Node)queryElement);
        }
        return sql;
    }

    private static final List<SQLParameter> getStoredProcedureParams(Exchange exchange, ConfigurationExtensions extensions, Logger logger) throws MessagingException {
        String externalizedSQLParameter;
        Short paramRank;
        ArrayList<SQLParameter> sqlParameters = new ArrayList<SQLParameter>();
        Element storedStatementElement = exchange.getInMessageContentAsDocument().getDocumentElement();
        if (!"storedProcedure".equals(storedStatementElement.getLocalName()) || !"http://petals.ow2.org/components/sql/version-1".equals(storedStatementElement.getNamespaceURI())) {
            exchange.setError((Exception)((Object)new MessagingException("The request message must contain a root element named 'storedProcedure' in the namespace 'http://petals.ow2.org/components/sql/version-1'")));
        } else {
            NodeList nodeList = storedStatementElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap attributes;
                Node rankAttribute;
                paramRank = null;
                Node parameterNode = nodeList.item(i);
                if (1 != parameterNode.getNodeType()) continue;
                if ("parameter".equals(parameterNode.getLocalName()) && (rankAttribute = (attributes = parameterNode.getAttributes()).getNamedItem("rank")) != null) {
                    try {
                        paramRank = Short.valueOf(rankAttribute.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (paramRank != null) {
                        externalizedSQLParameter = extensions.get((Object)("parameter" + paramRank));
                        if (externalizedSQLParameter == null) {
                            exchange.setError((Exception)((Object)new MessagingException("The request message contains a parameter with an unbound rank : " + paramRank)));
                            return null;
                        }
                        SQLParameter sqlParameter = new SQLParameter(externalizedSQLParameter, parameterNode.getTextContent());
                        if ("OUT".equals(sqlParameter.getScope())) {
                            exchange.setError((Exception)((Object)new MessagingException("The request message contains an illegal OUT parameter at rank : " + paramRank)));
                            return null;
                        }
                        sqlParameters.add(sqlParameter);
                        logger.finest("Found a SQL stored procedure parameter from the request message : " + sqlParameter);
                    }
                }
                if (paramRank != null) continue;
                exchange.setError((Exception)((Object)new MessagingException("The request message must contain only parameter elements named 'parameter' with integer attribute named 'rank' in the namespace 'http://petals.ow2.org/components/sql/version-1'")));
                return null;
            }
        }
        paramRank = 1;
        while ((externalizedSQLParameter = extensions.get((Object)("parameter" + paramRank))) != null) {
            Short s;
            boolean found = false;
            for (SQLParameter sqlParameter : sqlParameters) {
                if (sqlParameter.getRank() != paramRank.shortValue()) continue;
                found = true;
                break;
            }
            if (found) {
                Short i$ = paramRank;
                s = paramRank = Short.valueOf((short)(paramRank + 1));
                continue;
            }
            SQLParameter outSqlParameter = new SQLParameter(externalizedSQLParameter, "");
            if (!"OUT".equals(outSqlParameter.getScope())) {
                exchange.setError((Exception)((Object)new MessagingException("The parameter with rank " + paramRank + " has a " + outSqlParameter.getScope() + " scope and must be set in the request message")));
                return null;
            }
            s = paramRank;
            Short s2 = paramRank = Short.valueOf((short)(paramRank + 1));
            sqlParameters.add(outSqlParameter);
        }
        return sqlParameters;
    }

    private final boolean getShowMetadata(Exchange exchange) {
        boolean showMetadata = false;
        if (exchange.getProperty("metadata") != null && "true".equals(exchange.getProperty("metadata"))) {
            showMetadata = true;
        } else if (this.getExtensions().get((Object)"metadata", "false").equals("true")) {
            showMetadata = true;
        }
        try {
            if (exchange.getInMessageProperty("metadata") != null && "true".equals(exchange.getInMessageProperty("metadata"))) {
                showMetadata = true;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return showMetadata;
    }

    private static final boolean validateExchange(Exchange exchange) {
        boolean result = true;
        String operation = exchange.getOperationName().toLowerCase();
        if ("select".equals(operation)) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_OUT_PATTERN.value() + "'")));
                result = false;
            }
        } else if ("insert".equals(operation)) {
            if (!Message.MEPConstants.IN_ONLY_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_ONLY_PATTERN.value() + "'")));
                result = false;
            }
        } else if ("insertwithresponse".equals(operation)) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_OUT_PATTERN.value() + "'")));
                result = false;
            }
        } else if ("update".equals(operation)) {
            if (!Message.MEPConstants.IN_ONLY_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_ONLY_PATTERN.value() + "'")));
                result = false;
            }
        } else if ("updatewithresponse".equals(operation)) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_OUT_PATTERN.value() + "'")));
                result = false;
            }
        } else if ("delete".equals(operation)) {
            if (!Message.MEPConstants.IN_ONLY_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_ONLY_PATTERN.value() + "'")));
                result = false;
            }
        } else if ("deletewithresponse".equals(operation)) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_OUT_PATTERN.value() + "'")));
                result = false;
            }
        } else if ("storedprocedure".equals(operation)) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_OUT_PATTERN.value() + "'")));
                result = false;
            }
        } else if ("xmlstoredprocedure".equals(operation)) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_OUT_PATTERN.value() + "'")));
                result = false;
            }
        } else {
            exchange.setError((Exception)((Object)new MessagingException("Operation '" + operation + "' must have a valid local name.  Choices are :'" + "select" + "','" + "insert" + "','" + "insertwithresponse" + "','" + "update" + "updatewithresponse" + "','" + "delete" + "','" + "deletewithresponse" + "','" + "storedprocedure" + "','" + "xmlstoredprocedure" + "'")));
            result = false;
        }
        return result;
    }
}

