/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimePartDataSource
implements DataSource,
MessageAware {
    protected MimePart part;

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    public InputStream getInputStream() throws IOException {
        try {
            if (this.part instanceof MimeMessage) {
                return ((MimeMessage)this.part).getContentStream();
            }
            if (!(this.part instanceof MimeBodyPart)) {
                throw new MessagingException("Unknown part");
            }
            InputStream stream = ((MimeBodyPart)this.part).getContentStream();
            return this.checkPartEncoding(this.part, stream);
        }
        catch (MessagingException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private InputStream checkPartEncoding(MimePart part, InputStream stream) throws MessagingException {
        String encoding = part.getEncoding();
        if (encoding == null) {
            return stream;
        }
        if ((encoding = encoding.toLowerCase()).equals("7bit") || encoding.equals("8bit") || encoding.equals("binary")) {
            return stream;
        }
        String contentType = part.getContentType();
        if (contentType != null) {
            try {
                ContentType type = new ContentType(contentType);
                if (type.match("multipart/*")) {
                    return stream;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return MimeUtility.decode(stream, encoding);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String getName() {
        return "";
    }

    public synchronized MessageContext getMessageContext() {
        return new MessageContext(this.part);
    }
}

