/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.abstractElmt;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.api.extensions.SchemaLocatorImpl;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfImport;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInclude;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfTypes;

public abstract class AbstractDescriptionImpl<E, S extends AbsItfService<I, ? extends AbsItfEndpoint>, Ep extends AbsItfEndpoint, B extends AbsItfBinding, I extends AbsItfInterfaceType<? extends AbsItfOperation>, Incl extends AbsItfInclude<? extends AbsItfDescription>, Impt extends AbsItfImport<? extends AbsItfDescription>, T extends AbsItfTypes>
extends AbstractWSDLElementImpl<E>
implements AbsItfDescription<S, Ep, B, I, Incl, Impt, T> {
    private static final long serialVersionUID = 1L;
    protected Map<WSDLReader.FeatureConstants, Object> features = new HashMap<WSDLReader.FeatureConstants, Object>();
    protected NamespaceMapperImpl namespaceMapper = new NamespaceMapperImpl();
    protected List<Impt> imports = new ArrayList<Impt>();
    protected List<Incl> includes = new ArrayList<Incl>();
    protected List<S> services = new ArrayList<S>();
    protected List<B> bindings = new ArrayList<B>();
    protected List<I> interfaces = new ArrayList<I>();
    protected T types;
    protected URI documentURI;
    private SchemaLocatorImpl schemaLocator;

    public AbstractDescriptionImpl(URI baseURI, E model, NamespaceMapperImpl namespaceMapper, SchemaLocatorImpl schemaLocator, Map<WSDLReader.FeatureConstants, Object> features) throws WSDLException {
        super(model, null);
        this.features = features;
        this.namespaceMapper = namespaceMapper;
        this.schemaLocator = schemaLocator;
        this.documentURI = baseURI;
    }

    public AbstractDescriptionImpl() throws WSDLException {
    }

    protected void addImportElementsInAllList() {
        for (AbsItfImport impt : this.imports) {
            if (impt.getDescription() == null) continue;
            this.services.addAll(impt.getDescription().getServices());
            this.bindings.addAll(impt.getDescription().getBindings());
            this.interfaces.addAll(impt.getDescription().getInterfaces());
            if (this.types != null) {
                if (impt.getDescription().getTypes() == null) continue;
                this.types.getSchemas().addAll(impt.getDescription().getTypes().getSchemas());
                continue;
            }
            this.types = impt.getDescription().getTypes();
        }
    }

    protected void addIncludeElementsInAllList() {
        for (AbsItfInclude incl : this.includes) {
            if (incl.getDescription() == null) continue;
            this.services.addAll(incl.getDescription().getServices());
            this.bindings.addAll(incl.getDescription().getBindings());
            this.interfaces.addAll(incl.getDescription().getInterfaces());
            if (this.types != null) {
                this.types.getSchemas().addAll(incl.getDescription().getTypes().getSchemas());
                continue;
            }
            this.types = incl.getDescription().getTypes();
        }
    }

    protected void addIncludeElementsInAllList(AbsItfInclude incl) {
        if (incl.getDescription() != null) {
            this.services.addAll(incl.getDescription().getServices());
            this.bindings.addAll(incl.getDescription().getBindings());
            this.interfaces.addAll(incl.getDescription().getInterfaces());
            if (this.types != null) {
                this.types.getSchemas().addAll(incl.getDescription().getTypes().getSchemas());
            } else {
                this.types = incl.getDescription().getTypes();
            }
        }
    }

    @Override
    public void addImport(Impt impt) {
        if (this.imports == null) {
            this.imports = new ArrayList<Impt>();
        }
        this.imports.add(impt);
    }

    @Override
    public List<Impt> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<Impt>();
        }
        return this.imports;
    }

    @Override
    public List<Impt> getImports(String namespaceUri) {
        ArrayList<AbsItfImport> res = new ArrayList<AbsItfImport>();
        for (AbsItfImport impt : this.imports) {
            if (!impt.getNamespaceURI().equals(namespaceUri)) continue;
            res.add(impt);
        }
        return res;
    }

    @Override
    public void addInclude(Incl incl) throws WSDLException {
        if (this.includes == null) {
            this.includes = new ArrayList<Incl>();
        }
        this.includes.add(incl);
    }

    @Override
    public List<Incl> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<Incl>();
        }
        return this.includes;
    }

    @Override
    public Incl getInclude(URI locationUri) {
        if (this.includes.contains(locationUri)) {
            return (Incl)((AbsItfInclude)this.includes.get(this.includes.indexOf(locationUri)));
        }
        return null;
    }

    @Override
    public void addService(S service) {
        if (this.services == null) {
            this.services = new ArrayList<S>();
        }
        this.services.add(service);
    }

    @Override
    public List<S> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<S>();
        }
        return this.services;
    }

    @Override
    public S getService(QName name) {
        AbsItfService res = null;
        for (AbsItfService s : this.services) {
            if (!s.getQName().equals(name)) continue;
            res = s;
            break;
        }
        return (S)res;
    }

    @Override
    public void addBinding(B binding) {
        if (this.bindings == null) {
            this.bindings = new ArrayList<B>();
        }
        this.bindings.add(binding);
    }

    @Override
    public List<B> getBindings() {
        if (this.bindings == null) {
            this.bindings = new ArrayList<B>();
        }
        return this.bindings;
    }

    @Override
    public B getBinding(QName name) {
        AbsItfBinding res = null;
        for (AbsItfBinding b : this.bindings) {
            if (!b.getQName().equals(name)) continue;
            res = b;
            break;
        }
        return (B)res;
    }

    @Override
    public void addInterface(I itf) {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<I>();
        }
        this.interfaces.add(itf);
    }

    @Override
    public List<I> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<I>();
        }
        return this.interfaces;
    }

    @Override
    public I getInterface(QName name) {
        AbsItfInterfaceType res = null;
        for (AbsItfInterfaceType i : this.interfaces) {
            if (!i.getQName().equals(name)) continue;
            res = i;
            break;
        }
        return (I)res;
    }

    public Map<WSDLReader.FeatureConstants, Object> getFeatures() {
        if (this.features == null) {
            this.features = new HashMap<WSDLReader.FeatureConstants, Object>();
        }
        return this.features;
    }

    public Object getFeatureValue(WSDLReader.FeatureConstants feature) {
        if (this.features == null) {
            this.features = new HashMap<WSDLReader.FeatureConstants, Object>();
        }
        return this.features.get((Object)feature);
    }

    public void setFeatures(Map<WSDLReader.FeatureConstants, Object> features) {
        this.features = features;
    }

    @Override
    public T getTypes() {
        return this.types;
    }

    @Override
    public void setTypes(T types) {
        this.types = types;
    }

    @Override
    public NamespaceMapperImpl getNamespaces() {
        return this.namespaceMapper;
    }

    @Override
    public void addNamespace(String prefix, String namespaceURI) {
        this.namespaceMapper.addNamespace(prefix, namespaceURI);
    }

    @Override
    public URI getDocumentBaseURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentBaseURI(URI documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public Map<String, String> getSchemaLocation() {
        if (this.schemaLocator == null) {
            this.schemaLocator = new SchemaLocatorImpl();
        }
        return this.schemaLocator.getSchemaLocations();
    }

    @Override
    public List<Ep> findEndpointsImplementingInterface(I itf) {
        ArrayList<AbsItfEndpoint> endpoints = new ArrayList<AbsItfEndpoint>();
        if (itf != null) {
            for (AbsItfService service : this.getServices()) {
                for (AbsItfEndpoint endpoint : service.getEndpoints()) {
                    if (endpoint.getBinding() == null || endpoint.getBinding().getInterface() == null || !endpoint.getBinding().getInterface().getQName().getLocalPart().equals(itf.getQName().getLocalPart()) || !endpoint.getBinding().getInterface().getQName().getNamespaceURI().equals(itf.getQName().getNamespaceURI()) || endpoints.contains(endpoint)) continue;
                    endpoints.add(endpoint);
                }
            }
        }
        return endpoints;
    }

    public SchemaLocatorImpl getSchemaLocator() {
        return this.schemaLocator;
    }

    @Override
    public String toString() {
        return this.documentURI.toString();
    }
}

