/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sql.listener;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.bc.sql.service.SQLParameter;
import org.ow2.petals.bc.sql.service.SQLService;

public class OutStreamer
implements Runnable {
    private final PipedOutputStream pos = new PipedOutputStream();
    private final PipedInputStream pis = new PipedInputStream();
    private final ResultSet resultSet;
    private final List<SQLParameter> sqlParameters;
    private final SQLService sqlService;
    private final boolean showMetadata;
    private final Logger logger;
    private final Connection connection;
    private final boolean isXMLResult;

    public OutStreamer(SQLService sqlService, ResultSet resultSet, boolean showMetadata, Connection connection, Logger logger) throws IOException {
        this.sqlService = sqlService;
        this.showMetadata = showMetadata;
        this.logger = logger;
        this.resultSet = resultSet;
        this.sqlParameters = null;
        this.connection = connection;
        this.isXMLResult = false;
        this.pos.connect(this.pis);
    }

    public OutStreamer(SQLService sqlService, List<SQLParameter> sqlParameters, Connection connection, Logger logger, boolean isXMLResult) throws IOException {
        this.sqlService = sqlService;
        this.logger = logger;
        this.sqlParameters = sqlParameters;
        this.resultSet = null;
        this.connection = connection;
        this.pos.connect(this.pis);
        this.isXMLResult = isXMLResult;
        this.showMetadata = false;
    }

    public PipedInputStream getPipedInputStream() {
        return this.pis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.resultSet != null) {
                this.logger.finest("Build the response of the 'select' operation");
                this.sqlService.resultSetAsXMLOutputStream(this.resultSet, this.pos, this.showMetadata);
            } else {
                if (this.isXMLResult) {
                    this.logger.finest("Build the response of the 'xmlstoredprocedure' operation");
                } else {
                    this.logger.finest("Build the response of the 'storedprocedure' operation");
                }
                this.sqlService.sqlParametersAsXMLOutputStream(this.sqlParameters, this.pos, this.isXMLResult);
            }
            this.pos.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

