/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.ExtensionMBean;
import org.ow2.petals.component.framework.JBIBootstrap;
import org.ow2.petals.component.framework.api.util.PropertiesUtil;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.SettableanyURI;
import org.ow2.petals.component.framework.mbean.MBeanHelper;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;

public class DefaultBootstrap
extends JBIBootstrap {
    protected ObjectName mbeanName;

    @Override
    public ObjectName getExtensionMBeanName() {
        MBeanServer server = this.installContext.getContext().getMBeanServer();
        ObjectName objName = server.isRegistered(this.mbeanName) ? this.mbeanName : null;
        return objName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInstall() throws JBIException {
        this.getLogger().info(this.getComponentMessageInfo());
        File jbiXmlFile = new File(this.getInstallContext().getInstallRoot() + File.separator + "META-INF" + File.separator + "jbi.xml");
        this.validateComponentSettableConfiguration();
        try {
            FileOutputStream jbiOutputStream = new FileOutputStream(jbiXmlFile);
            try {
                JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)this.getJbiComponentConfiguration(), (OutputStream)jbiOutputStream);
            }
            finally {
                jbiOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new JBIException("Failed to persist the installation configuration : " + e.getMessage());
        }
        catch (CDKJBIDescriptorException e) {
            throw new JBIException("Failed to persist the installation configuration : " + e.getMessage(), (Throwable)e);
        }
        try {
            this.processNativeWSDLResource(this.getInstallContext().getContext().getWorkspaceRoot() + File.separator + "native-service");
        }
        catch (WSDLException e) {
            throw new JBIException("An error occurred while copying the native wsdl resource : " + e.getMessage());
        }
    }

    @Override
    public void cleanUp() throws JBIException {
        MBeanServer server = this.installContext.getContext().getMBeanServer();
        if (server.isRegistered(this.mbeanName)) {
            try {
                server.unregisterMBean(this.mbeanName);
            }
            catch (InstanceNotFoundException e) {
                throw new JBIException("Error during bootstrap clean up : " + e.getMessage());
            }
            catch (MBeanRegistrationException e) {
                throw new JBIException("Error during bootstrap clean up" + e.getMessage());
            }
        }
        super.cleanUp();
    }

    @Override
    protected void doInit() throws JBIException {
        this.mbeanName = this.installContext.getContext().getMBeanNames().createCustomComponentMBeanName("bootstrap_" + this.installContext.getComponentName());
        MBeanHelper.registerMBean(this.installContext.getContext().getMBeanServer(), this.mbeanName, new ExtensionMBean(this));
    }

    protected List<String> getMethodList() {
        return new ArrayList<String>();
    }

    protected List<String> getAttributeList() {
        return new ArrayList<String>();
    }

    private void validateComponentSettableConfiguration() throws JBIException {
        SettableanyURI propertiesFile = this.getJbiComponentConfiguration().getComponent().getPropertiesFile();
        if (propertiesFile != null && !StringHelper.isNullOrEmpty((String)propertiesFile.getValue())) {
            try {
                PropertiesUtil.loadProperties((String)propertiesFile.getValue());
            }
            catch (PropertiesException e) {
                throw new JBIException(e.getMessage());
            }
        }
    }

    private void processNativeWSDLResource(String workRootPath) throws WSDLException {
        URL nativeWsdlURL;
        File nativeWSDLFile;
        File workspace = new File(workRootPath);
        if (!workspace.exists()) {
            workspace.mkdirs();
        }
        if ((nativeWSDLFile = new File(workspace, "component.wsdl")) != null && !nativeWSDLFile.exists() && (nativeWsdlURL = this.getClass().getClassLoader().getResource("component.wsdl")) != null) {
            Description wsdlDescription = WSDLUtilImpl.createWsdlDescription(nativeWsdlURL, true);
            WSDLUtilImpl.convertDescriptionToFile(wsdlDescription, nativeWSDLFile);
        }
    }

    private String getComponentMessageInfo() {
        String componentVersion = "Version not set";
        String clazz = this.getJbiComponentConfiguration().getComponent().getJbiListenerClassName();
        try {
            Class<?> clazz2 = Class.forName(clazz, false, this.getClass().getClassLoader());
            if (clazz2 != null && StringHelper.isNullOrEmpty((String)(componentVersion = clazz2.getPackage().getImplementationVersion()))) {
                componentVersion = "Version not set";
            }
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        String result = "Install component [Name : " + this.getInstallContext().getComponentName() + ", Version : " + componentVersion + "]";
        return result;
    }
}

