/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.mbean;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Runtimepositivestrictint;
import org.ow2.petals.component.framework.jbidescriptor.generated.Runtimepositivestrictlong;

public class RuntimeConfigurationNotifier
implements DynamicMBean,
NotificationEmitter {
    private final NotificationBroadcasterSupport broadcasterSupport;
    private ObjectName mbeanName;
    private final AtomicLong seqNumber;
    private final Logger logger;
    private final Jbi jbiComponentConfiguration;
    private final File jbiComponentFile;

    public RuntimeConfigurationNotifier(Jbi jbiComponentConfiguration, File jbiComponentFile, Logger logger) {
        this.jbiComponentConfiguration = jbiComponentConfiguration;
        this.jbiComponentFile = jbiComponentFile;
        this.broadcasterSupport = new NotificationBroadcasterSupport();
        this.seqNumber = new AtomicLong(0L);
        this.logger = logger;
    }

    private Field findInheritedField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Class<?> currentClazz = clazz;
        while (currentClazz != null) {
            try {
                return currentClazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if ((currentClazz = currentClazz.getSuperclass()) != null) continue;
                throw e;
            }
        }
        return null;
    }

    @Override
    public synchronized Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object attributeObject = null;
        try {
            Field field = Component.class.getDeclaredField(attribute);
            field.setAccessible(true);
            Object gettableObject = field.get(this.jbiComponentConfiguration.getComponent());
            if (gettableObject != null) {
                String methodName = "getValue";
                if (field.getType().getSimpleName().endsWith("boolean")) {
                    methodName = "isValue";
                }
                Method method = gettableObject.getClass().getMethod(methodName, new Class[0]);
                attributeObject = method.invoke(gettableObject, new Object[0]);
            }
        }
        catch (SecurityException e) {
            throw new AttributeNotFoundException("Attribute '" + attribute + "' is not reachable");
        }
        catch (NoSuchFieldException e) {
            throw new AttributeNotFoundException("Attribute '" + attribute + "' does not exist");
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e, e.getMessage());
        }
        return attributeObject;
    }

    @Override
    public synchronized AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            try {
                list.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (AttributeNotFoundException e) {
                this.logger.warning("Failed to get attribute '" + attribute + "' in the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
            catch (MBeanException e) {
                this.logger.warning("Failed to get attribute '" + attribute + "' in the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
            catch (ReflectionException e) {
                this.logger.warning("Failed to get attribute '" + attribute + "' in the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
        }
        return list;
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Field field = Component.class.getDeclaredField(attribute.getName());
            if (field.getType().equals(Runtimepositivestrictint.class)) {
                int messageProcessorMaxPoolSizeAttrValue;
                Object processorPoolSizeAttr = this.getAttribute("processorPoolSize");
                int processorPoolSizeAttrValue = (Integer)processorPoolSizeAttr;
                Object processorMaxPoolSizeAttr = this.getAttribute("processorMaxPoolSize");
                int processorMaxPoolSizeAttrValue = processorMaxPoolSizeAttr == null ? 50 : (Integer)processorMaxPoolSizeAttr;
                Object messageProcessorMaxPoolSizeAttr = this.getAttribute("messageProcessorMaxPoolSize");
                int n = messageProcessorMaxPoolSizeAttrValue = messageProcessorMaxPoolSizeAttr == null ? processorMaxPoolSizeAttrValue : (Integer)messageProcessorMaxPoolSizeAttr;
                if (field.getName().equals("processorMaxPoolSize") && (Integer)attribute.getValue() <= processorPoolSizeAttrValue) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be upper or equals to the processor core pool size.");
                }
                if (field.getName().equals("processorMaxPoolSize") && (Integer)attribute.getValue() > messageProcessorMaxPoolSizeAttrValue) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be lower or equals to the message processor max pool size.");
                }
                if (field.getName().equals("processorPoolSize") && (Integer)attribute.getValue() > processorMaxPoolSizeAttrValue) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be lower or equals to the processor max pool size (" + processorMaxPoolSizeAttrValue + ").");
                }
                if (field.getName().equals("messageProcessorMaxPoolSize") && (Integer)attribute.getValue() < processorMaxPoolSizeAttrValue) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be upper or equals to the processor max pool size (" + processorMaxPoolSizeAttrValue + ").");
                }
                if ((Integer)attribute.getValue() <= 0) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be upper or equals to 1.");
                }
            } else if (field.getType().equals(Runtimepositivestrictlong.class) && ((Long)attribute.getValue()).intValue() <= 0) {
                throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be upper or equals to 1.");
            }
            field.setAccessible(true);
            Object settableObject = field.get(this.jbiComponentConfiguration.getComponent());
            String methodName = "getValue";
            if (field.getType().getSimpleName().endsWith("boolean")) {
                methodName = "isValue";
            }
            Method method = settableObject.getClass().getMethod(methodName, new Class[0]);
            Object value = method.invoke(settableObject, new Object[0]);
            Field primitiveField = this.findInheritedField(field.getType(), "value");
            method = settableObject.getClass().getMethod("setValue", primitiveField.getType());
            method.invoke(settableObject, attribute.getValue());
            this.saveAndNotifyListeners(attribute.getName() + "modified", attribute.getName(), value, attribute.getValue());
        }
        catch (SecurityException e) {
            throw new AttributeNotFoundException("Attribute '" + attribute.getName() + "' is not reachable");
        }
        catch (NoSuchFieldException e) {
            throw new AttributeNotFoundException("Attribute '" + attribute.getName() + "' does not exist");
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList list) {
        AttributeList attributeList = new AttributeList();
        for (Object object : list) {
            Attribute attribute = (Attribute)object;
            try {
                this.setAttribute(attribute);
            }
            catch (AttributeNotFoundException e) {
                this.logger.warning("Failed to set attribute '" + attribute.getName() + "' in the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
            catch (InvalidAttributeValueException e) {
                this.logger.warning("Failed to set attribute '" + attribute.getName() + "' in the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
            catch (MBeanException e) {
                this.logger.warning("Failed to set attribute '" + attribute.getName() + "' in the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
            catch (ReflectionException e) {
                this.logger.warning("Failed to set attribute '" + attribute.getName() + "' in the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
        }
        return attributeList;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attrs = this.getAttributesInfos();
        MBeanNotificationInfo notif = new MBeanNotificationInfo(null, "Runtime MBean notifier", "Runtime configuration modification notifier");
        MBeanNotificationInfo[] notifs = new MBeanNotificationInfo[]{notif};
        return new MBeanInfo(this.getClass().getName(), "Property Manager MBean", attrs, null, null, notifs);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "Change runtime configuration attribute")};
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcasterSupport.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener, filter, handback);
    }

    public ObjectName getMBeanName() {
        return this.mbeanName;
    }

    public void setMBeanName(ObjectName mbeanName) {
        this.mbeanName = mbeanName;
    }

    protected MBeanAttributeInfo[] getAttributesInfos() {
        MBeanAttributeInfo[] attrs = null;
        Field[] fields = Component.class.getDeclaredFields();
        ArrayList<Field> settableFields = new ArrayList<Field>();
        try {
            for (Field field : fields) {
                if (!field.getType().getSimpleName().startsWith("Runtime")) continue;
                field.setAccessible(true);
                if (field.get(this.jbiComponentConfiguration.getComponent()) == null) continue;
                settableFields.add(field);
            }
            attrs = new MBeanAttributeInfo[settableFields.size()];
            for (Field field : settableFields) {
                Object settableObject = field.get(this.jbiComponentConfiguration.getComponent());
                Method getter = field.getType().getSimpleName().endsWith("boolean") ? settableObject.getClass().getMethod("isValue", new Class[0]) : settableObject.getClass().getMethod("getValue", new Class[0]);
                Field primitiveField = this.findInheritedField(field.getType(), "value");
                Method setter = settableObject.getClass().getMethod("setValue", primitiveField.getType());
                attrs[settableFields.indexOf((Object)field)] = new MBeanAttributeInfo(field.getName(), "Property " + field.getName(), getter, setter);
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (SecurityException e) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (IntrospectionException e) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAndNotifyListeners(String msg, String attrName, Object oldVal, Object newVal) {
        FileOutputStream jbiComponentFileAsOutputStream = null;
        try {
            jbiComponentFileAsOutputStream = new FileOutputStream(this.jbiComponentFile);
            JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)this.jbiComponentConfiguration, (OutputStream)jbiComponentFileAsOutputStream);
        }
        catch (FileNotFoundException e) {
            this.logger.warning("Failed to pesist modification of the runtime configuration MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (CDKJBIDescriptorException e) {
            this.logger.warning("Failed to pesist modification of the runtime configuration MBean : " + ((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage());
        }
        finally {
            try {
                if (jbiComponentFileAsOutputStream != null) {
                    ((OutputStream)jbiComponentFileAsOutputStream).close();
                }
            }
            catch (IOException ex) {
                this.logger.warning("Can't close jbi component file output stream : " + ex.getMessage());
            }
        }
        AttributeChangeNotification notif = new AttributeChangeNotification(this, this.seqNumber.getAndIncrement(), System.currentTimeMillis(), msg, attrName, String.class.getName(), oldVal, newVal);
        this.broadcasterSupport.sendNotification(notif);
    }
}

