/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.MessageExchangeAcceptor;

public class JBIAcceptorThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final Logger logger;
    private final AbstractComponent component;
    private final JBIProcessorManager jbiProcessorManager;

    public JBIAcceptorThreadFactory(AbstractComponent component, JBIProcessorManager jbiProcessorManager, Logger logger) {
        this.component = component;
        this.jbiProcessorManager = jbiProcessorManager;
        this.logger = logger;
        this.group = new ThreadGroup(Thread.currentThread().getThreadGroup(), this.component.getContext().getComponentName() + "-JBIListener");
    }

    public MessageExchangeAcceptor newThread(int nbMaxTry, long baseWaitDuration) {
        String name = this.component.getContext().getComponentName() + " -JBI Acceptor Thread #" + Integer.toString(this.threadNumber.getAndIncrement());
        this.logger.log(Level.FINE, "Creating a new thread for JBIAcceptor Factory : " + name);
        MessageExchangeAcceptor meaProcessor = new MessageExchangeAcceptor(this.component, this.jbiProcessorManager, this.logger, this.group, name, nbMaxTry, baseWaitDuration);
        meaProcessor.setDaemon(true);
        return meaProcessor;
    }

    protected void finalize() throws Throwable {
        this.group.destroy();
    }
}

