/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.NoSuchElementException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolUtils;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.JBIProcessorManagerObservable;
import org.ow2.petals.component.framework.process.JBIProcessorThreadFactory;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;
import org.ow2.petals.component.framework.process.MessageExchangeProcessorObjectFactory;
import org.ow2.petals.component.framework.process.MessageExchangeProcessorThreadPoolExecutor;

public class JBIProcessorManager
extends JBIProcessorManagerObservable
implements NotificationListener {
    public static final int DEFAULT_PROCESSOR_POOL_SIZE_MAX = 50;
    protected static final int DEFAULT_PROCESSOR_POOL_SIZE_KEEP_ALIVE_TIME = 300;
    protected static final int DEFAULT_PROCESSOR_STOP_MAX_WAIT = 15000;
    private ThreadPoolExecutor processorPool = null;
    private GenericObjectPool processorObjectPool = null;
    private final AbstractComponent component;
    private final RuntimeConfigurationNotifier runtimeConfiguration;
    private final Logger logger;

    public JBIProcessorManager(AbstractComponent component, RuntimeConfigurationNotifier runtimeConfiguration, Logger logger) {
        this.component = component;
        this.runtimeConfiguration = runtimeConfiguration;
        this.logger = logger;
    }

    public void init() throws JBIException {
        this.runtimeConfiguration.addNotificationListener(this, null, null);
    }

    public void shutdown() throws JBIException {
        try {
            this.runtimeConfiguration.removeNotificationListener(this, null, null);
        }
        catch (ListenerNotFoundException e) {
            throw new JBIException("Error unregistering the runtime configuration listener", (Throwable)e);
        }
    }

    public void start() throws JBIException {
        int msgProcessorMaxPoolSize;
        int processorPoolKeepAliveTime;
        this.logger.fine("Creating JBI Processor pool:");
        int coreProcessorPoolSize = this.component.getComponentConfiguration().getProcessorPoolSize().getValue();
        int maxProcessorPoolSize = this.component.getComponentConfiguration().getProcessorMaxPoolSize() != null ? this.component.getComponentConfiguration().getProcessorMaxPoolSize().getValue() : 50;
        if (coreProcessorPoolSize > maxProcessorPoolSize) {
            int previousMax = maxProcessorPoolSize;
            maxProcessorPoolSize = coreProcessorPoolSize;
            this.logger.warning("The value of 'processor-pool-size' (" + coreProcessorPoolSize + ") is invalid, greater than 'processor-max-pool-size' (" + previousMax + "). The value of 'processor-max-pool-size' is set to the value of 'processor-pool-size'");
        }
        if (this.component.getComponentConfiguration().getProcessorKeepAliveTime() != null) {
            processorPoolKeepAliveTime = this.component.getComponentConfiguration().getProcessorKeepAliveTime().getValue();
            if (processorPoolKeepAliveTime <= 0) {
                this.logger.warning("The value of 'processor-keep-alive-time' (" + processorPoolKeepAliveTime + ") is invalid. The value must be strictly upper to 0.");
                processorPoolKeepAliveTime = 300;
            }
        } else {
            processorPoolKeepAliveTime = 300;
        }
        if (this.component.getComponentConfiguration().getMessageProcessorMaxPoolSize() != null) {
            msgProcessorMaxPoolSize = this.component.getComponentConfiguration().getMessageProcessorMaxPoolSize().getValue();
            if (msgProcessorMaxPoolSize <= 0) {
                this.logger.warning("The value of 'message-processor-max-pool-size' (" + msgProcessorMaxPoolSize + ") is invalid. The value must be strictly upper to 0.");
                msgProcessorMaxPoolSize = maxProcessorPoolSize;
            }
        } else {
            msgProcessorMaxPoolSize = maxProcessorPoolSize;
        }
        if (msgProcessorMaxPoolSize < maxProcessorPoolSize) {
            int previousMax = msgProcessorMaxPoolSize;
            msgProcessorMaxPoolSize = maxProcessorPoolSize;
            this.logger.warning("The value of 'message-processor-max-pool-size' (" + previousMax + ") is invalid, lower than 'processor-max-pool-size' (" + maxProcessorPoolSize + "). The value of 'message-processor-max-pool-size' is set to the value of 'processor-max-pool-size'");
        }
        this.logger.fine("\t- core pool size: " + coreProcessorPoolSize);
        this.logger.fine("\t- max core pool size: " + maxProcessorPoolSize);
        this.logger.fine("\t- keep alive time: " + processorPoolKeepAliveTime);
        this.logger.fine("\t- message processoir max pool size: " + msgProcessorMaxPoolSize);
        this.processorObjectPool = new GenericObjectPool((PoolableObjectFactory)new MessageExchangeProcessorObjectFactory(this.component, this.logger), msgProcessorMaxPoolSize, 0, -1L, 8, coreProcessorPoolSize, false, false, 600000L, -33, (long)processorPoolKeepAliveTime, false);
        try {
            PoolUtils.prefill((ObjectPool)this.processorObjectPool, (int)coreProcessorPoolSize);
        }
        catch (IllegalArgumentException e) {
            throw new JBIException((Throwable)e);
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
        this.processorPool = new MessageExchangeProcessorThreadPoolExecutor(coreProcessorPoolSize, maxProcessorPoolSize, processorPoolKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new JBIProcessorThreadFactory(this.component, this.logger), this.processorObjectPool, this.jbiProccesorManagerObservers, this.logger);
        this.processorPool.prestartAllCoreThreads();
    }

    public void stop() {
        this.processorPool.shutdown();
        try {
            long processorStopMaxWait;
            if (this.component.getComponentConfiguration().getProcessorStopMaxWait() != null) {
                processorStopMaxWait = this.component.getComponentConfiguration().getProcessorStopMaxWait().getValue();
                if (processorStopMaxWait <= 0L) {
                    this.logger.warning("The value of 'processor-stop-max-time' (" + processorStopMaxWait + ") is invalid. The value must be strictly upper to 0.");
                    processorStopMaxWait = 15000L;
                }
            } else {
                processorStopMaxWait = 15000L;
            }
            this.processorPool.awaitTermination(processorStopMaxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Workers pool interrupted : " + e.getMessage());
        }
        this.processorPool.shutdownNow();
        try {
            this.processorObjectPool.close();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to close the Messsage Exchange Processor Object pool properly", e);
        }
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.processorPool;
    }

    public GenericObjectPool getObjectPool() {
        return this.processorObjectPool;
    }

    protected void setCorePoolSize(int size) {
        this.logger.info("Reset the processor thread pool size to " + size);
        try {
            this.processorPool.setCorePoolSize(size);
            this.processorPool.prestartAllCoreThreads();
            this.processorObjectPool.setMinIdle(size);
        }
        catch (IllegalArgumentException e) {
            String warningMessage = String.format("Invalid value used (less than or equal to zero) to configure the processor thread pool core size: %d", size);
            this.logger.warning(warningMessage);
        }
    }

    protected void setMaxCorePoolSize(int size) {
        this.logger.info("Reset the maximum processor thread pool size to " + size);
        try {
            this.processorPool.setMaximumPoolSize(size);
            this.processorObjectPool.setMaxActive(size);
        }
        catch (IllegalArgumentException e) {
            String warningMessage = String.format("Invalid value used (less than or equal to zero, or less than the core pool size) to configure the processor thread pool max size: %d", size);
            this.logger.warning(warningMessage);
        }
    }

    protected void setPoolKeepAliveTime(int time) {
        this.logger.info("Reset the processor thread pool keep alive time to " + time);
        try {
            this.processorPool.setKeepAliveTime(time, TimeUnit.SECONDS);
            this.processorObjectPool.setMinEvictableIdleTimeMillis((long)(time * 1000));
        }
        catch (IllegalArgumentException e) {
            String warningMessage = String.format("Invalid value used (less than or equal to zero) to configure the processor thread pool keep alive time: %d", time);
            this.logger.warning(warningMessage);
        }
    }

    protected void setMessageProcessorMaxPoolSize(int size) {
        this.logger.info("Reset the message processor max pool size to " + size);
        if (size <= 0) {
            String warningMessage = String.format("Invalid value used (less than or equal to zero) to configure the message processor max pool size: %d", size);
            this.logger.warning(warningMessage);
        } else if (size < this.processorPool.getMaximumPoolSize()) {
            String warningMessage = String.format("Invalid value used (lower than the processor thread pool max size: %d) to configure the message processor max pool size: %d", this.processorPool.getMaximumPoolSize(), size);
            this.logger.warning(warningMessage);
        } else {
            this.processorObjectPool.setMaxActive(size);
        }
    }

    public void process(ExchangeImpl exchange, int nbMaxTry, long baseWaitDuration) throws InterruptedException {
        int nbTry = 0;
        long waitDuration = 0L;
        for (int i = 0; i < nbMaxTry; ++i) {
            try {
                MessageExchangeProcessor messageExchangeProcessor;
                try {
                    messageExchangeProcessor = (MessageExchangeProcessor)this.processorObjectPool.borrowObject();
                }
                catch (Exception e) {
                    if (e instanceof NoSuchElementException) {
                        throw (NoSuchElementException)e;
                    }
                    if (nbTry == nbMaxTry) {
                        this.logger.log(Level.WARNING, "Try #" + i + ". An unknown error occurs borrowing a message exchange processor from the pool. The message exchange is lost", e);
                        return;
                    }
                    waitDuration = waitDuration + baseWaitDuration * (long)(i + 1) + (long)(10.0 * Math.random());
                    this.logger.log(Level.WARNING, "Try #" + i + ". An unknown error occurs borrowing a message exchange processor from the pool. Wait " + waitDuration + "ms before next try.", e);
                    continue;
                }
                if (messageExchangeProcessor == null) {
                    throw new NoSuchElementException("No more JBI message exchange processor is available in the pool.");
                }
                messageExchangeProcessor.setMessageExchange(exchange);
                try {
                    this.processorPool.execute(messageExchangeProcessor);
                    break;
                }
                catch (RejectedExecutionException e) {
                    messageExchangeProcessor.clean();
                    try {
                        this.processorObjectPool.returnObject((Object)messageExchangeProcessor);
                    }
                    catch (Exception e1) {
                        this.logger.log(Level.WARNING, "A error occurs returning the message exchange processor to the pool. It is ignored.", e1);
                    }
                    throw e;
                }
            }
            catch (NoSuchElementException e) {
                if (nbTry == nbMaxTry) {
                    this.logger.warning("Try #" + i + ". No more JBI message exchange processor is available in the pool, and the try number is reached. Message discarded.");
                    continue;
                }
                waitDuration = waitDuration + baseWaitDuration * (long)(i + 1) + (long)(10.0 * Math.random());
                this.logger.warning("Try #" + i + ". No JBI message exchange processor is available in the pool. Wait " + waitDuration + "ms before next try.");
                Thread.sleep(waitDuration);
                continue;
            }
            catch (RejectedExecutionException e) {
                if (nbTry == nbMaxTry) {
                    this.logger.warning("Try #" + i + ". No more thread is available to execute a JBI message exchange processor, and the try number is reached. Message discarded.");
                    continue;
                }
                waitDuration = waitDuration + baseWaitDuration * (long)(i + 1) + (long)(10.0 * Math.random());
                this.logger.warning("Try #" + i + ". No thread is available to execute a JBI message exchange processor. Wait " + waitDuration + "ms before next try.");
                Thread.sleep(waitDuration);
            }
        }
    }

    @Override
    public void handleNotification(Notification notification, Object obj) {
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification attrNotif = (AttributeChangeNotification)notification;
            String attrName = attrNotif.getAttributeName();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Notification received by " + this.getClass().getName() + " for attribute : " + attrName);
            }
            if (attrName.equals("processorPoolSize")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setCorePoolSize(newVal);
            } else if (attrName.equals("processorMaxPoolSize")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setMaxCorePoolSize(newVal);
            } else if (attrNotif.getAttributeName().equals("processorKeepAliveTime")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setPoolKeepAliveTime(newVal);
            } else if (attrNotif.getAttributeName().equals("messageProcessorMaxPoolSize")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setMessageProcessorMaxPoolSize(newVal);
            } else {
                this.logger.log(Level.FINE, "Notification ignored by " + this.getClass().getName() + " for attribute : " + attrName);
            }
        }
    }
}

