/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.JBIProcessorManager;

public class MessageExchangeAcceptor
extends Thread {
    private final Logger logger;
    private final DeliveryChannel deliveryChannel;
    private volatile boolean running = false;
    private final Object runningLock = new Object();
    private final JBIProcessorManager jbiProcessorManager;
    private final int nbMaxTry;
    private final long baseWaitDuration;

    public MessageExchangeAcceptor(AbstractComponent component, JBIProcessorManager jbiProcessorManager, Logger logger, ThreadGroup threadGroup, String threadName, int nbMaxTry, long baseWaitDuration) {
        super(threadGroup, threadName);
        this.jbiProcessorManager = jbiProcessorManager;
        this.deliveryChannel = component.getChannel();
        this.nbMaxTry = nbMaxTry;
        this.baseWaitDuration = baseWaitDuration;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.log(Level.FINE, "Starting MessageExchangeAcceptor Thread " + this.getName());
        this.running = true;
        while (this.running) {
            try {
                ExchangeImpl exchange = new ExchangeImpl(this.deliveryChannel.accept());
                this.logger.fine("Accepting a JBI message with Id : " + exchange.getExchangeId());
                this.jbiProcessorManager.process(exchange, this.nbMaxTry, this.baseWaitDuration);
            }
            catch (Throwable e) {
                Object object = this.runningLock;
                synchronized (object) {
                    for (Throwable cause = e; cause != null && this.running; cause = cause.getCause()) {
                        if (!(cause instanceof InterruptedException)) continue;
                        this.running = false;
                        this.logger.fine("Thread '" + this.getName() + "' interrupted, stop accepting JBI messages");
                    }
                    if (this.running) {
                        this.logger.log(Level.INFO, "An unexpected exception occurs during the processing of the JBI acceptor '" + this.getName() + "'", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ends() {
        Object object = this.runningLock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                this.logger.fine("Thread '" + this.getName() + "' will stop to accept JBI messages.");
            }
        }
    }
}

