/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MtomUtil {
    public static final String MTOM_NSURI = "http://www.w3.org/2004/08/xop/include";
    public static final String NODE_ATTACHMENTS = "attachments";

    public static boolean compare(String attachmentElementValue, String attachmentName) {
        if (attachmentElementValue.equals(attachmentName)) {
            return true;
        }
        try {
            String encodedText2 = URLEncoder.encode(attachmentName, "UTF-8");
            if (attachmentElementValue.equals(encodedText2)) {
                return true;
            }
            String encodedText1 = attachmentElementValue.replace("@", "%40");
            if (encodedText1.equals(encodedText2)) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    public static final String convertQNameToString(QName qname) {
        return qname.getPrefix().length() > 0 ? qname.getPrefix() + ":" + qname.getLocalPart() : qname.getLocalPart();
    }

    @Deprecated
    public static Element extractAttachmentRootElement(Document inputDocument) throws MessagingException {
        NodeList attachmentsCandidatesList = inputDocument.getElementsByTagNameNS("*", NODE_ATTACHMENTS);
        if (attachmentsCandidatesList.getLength() != 1) {
            throw new MessagingException("xml element : 'attachments' not found.");
        }
        Element attachmentsRootElement = (Element)attachmentsCandidatesList.item(0);
        return attachmentsRootElement;
    }

    public static Set<String> extractAttachmentsIdFromPayload(Element attachmentRootElement) {
        HashSet<String> attachmentIds = new HashSet<String>();
        String attachmentId = null;
        NodeList includeNodes = attachmentRootElement.getElementsByTagNameNS(MTOM_NSURI, "*");
        for (int i = 0; i < includeNodes.getLength(); ++i) {
            Node n = includeNodes.item(i);
            if (!"include".equalsIgnoreCase(MtomUtil.getNodeName(n))) continue;
            attachmentId = ((Element)n).getAttribute("href").replaceFirst("cid:", "");
            attachmentIds.add(attachmentId);
        }
        return attachmentIds;
    }

    public static DocumentFragment generateMtomStructure(Document document, List<String> contentIds, QName element) {
        DocumentFragment fragment = document.createDocumentFragment();
        String qnameAsString = MtomUtil.convertQNameToString(element);
        Element elt = null;
        for (String cId : contentIds) {
            elt = document.createElementNS(element.getNamespaceURI(), qnameAsString);
            elt.appendChild(MtomUtil.generateMtomXopElement(document, cId));
            fragment.appendChild(elt);
        }
        return fragment;
    }

    public static Node generateMtomStructure(Document document, List<String> contentIds, QName rootNode, QName customNode) {
        Element rootElt = document.createElementNS(rootNode.getNamespaceURI(), MtomUtil.convertQNameToString(rootNode));
        DocumentFragment docFragment = MtomUtil.generateMtomStructure(document, contentIds, customNode);
        rootElt.appendChild(docFragment);
        return rootElt;
    }

    public static Node generateMtomXopElement(Document doc, String contentId) {
        Element includeElt = doc.createElementNS(MTOM_NSURI, "xop:Include");
        includeElt.setAttribute("href", "cid:" + contentId);
        return includeElt;
    }

    @Deprecated
    public static Map<String, DataHandler> getAttachments(Document inputDocument, NormalizedMessage nmMessage) throws MessagingException {
        HashMap<String, DataHandler> mAttachments = new HashMap<String, DataHandler>();
        Element attachmentRootElement = MtomUtil.extractAttachmentRootElement(inputDocument);
        Set<String> attachmentIds = MtomUtil.extractAttachmentsIdFromPayload(attachmentRootElement);
        if (attachmentIds.size() == 0) {
            throw new MessagingException("no attachment id was found in the message payload");
        }
        for (String id : attachmentIds) {
            for (Object obj : nmMessage.getAttachmentNames()) {
                String jbiAttachmentId = (String)obj;
                if (!MtomUtil.compare(id, jbiAttachmentId)) continue;
                mAttachments.put(jbiAttachmentId, nmMessage.getAttachment(jbiAttachmentId));
            }
        }
        if (mAttachments.size() != attachmentIds.size()) {
            StringBuilder builder = new StringBuilder();
            builder.append("error when comparing the attachments id | ");
            builder.append("payload attachment id found : " + attachmentIds.toString() + " | ");
            builder.append("normalized message attachment id found : " + nmMessage.getAttachmentNames().toString());
            throw new MessagingException(builder.toString());
        }
        return mAttachments;
    }

    public static MtomMapping getMtomMapping(Exchange exchange, Element element) throws MessagingException {
        Document doc;
        MtomMapping result = null;
        if (element == null && (doc = exchange.getInMessageContentAsDocument(true)) != null && doc.getDocumentElement() != null) {
            element = doc.getDocumentElement();
        }
        if (element != null) {
            result = new MtomMapping();
            Set<String> contentIds = MtomUtil.extractAttachmentsIdFromPayload(element);
            ArrayList<DataHandler> allTheDataHandlers = new ArrayList<DataHandler>();
            for (String attName : exchange.getInMessageAttachmentNames()) {
                allTheDataHandlers.add(exchange.getInMessageAttachment(attName));
            }
            for (String contentId : contentIds) {
                DataHandler dataHandler = null;
                for (String attName : exchange.getInMessageAttachmentNames()) {
                    if (!MtomUtil.compare(contentId, attName)) continue;
                    dataHandler = exchange.getInMessageAttachment(attName);
                    break;
                }
                if (dataHandler != null) {
                    allTheDataHandlers.remove(dataHandler);
                    result.put(contentId, dataHandler);
                    continue;
                }
                result.add(contentId);
            }
            result.addAll(allTheDataHandlers);
        }
        return result;
    }

    public static String getNodeName(Node node) {
        String name;
        String string = name = node.getNamespaceURI() != null ? node.getLocalName() : node.getNodeName();
        if (name.contains(":")) {
            String[] parts = name.split(":");
            name = parts[parts.length - 1];
        }
        return name;
    }

    public static class MtomMapping {
        private final Map<String, DataHandler> contentIdToDataHandler = new HashMap<String, DataHandler>();
        private final Set<String> orphanContentIds = new HashSet<String>();
        private final List<DataHandler> orphanDataHandlers = new ArrayList<DataHandler>();

        public Map<String, DataHandler> getContentIdToDataHandler() {
            return this.contentIdToDataHandler;
        }

        public Set<String> getOrphanContentIds() {
            return this.orphanContentIds;
        }

        public List<DataHandler> getOrphanDataHandlers() {
            return this.orphanDataHandlers;
        }

        boolean add(DataHandler o) {
            return this.orphanDataHandlers.add(o);
        }

        boolean add(String o) {
            return this.orphanContentIds.add(o);
        }

        boolean addAll(Collection<? extends DataHandler> c) {
            return this.orphanDataHandlers.addAll(c);
        }

        DataHandler put(String key, DataHandler value) {
            return this.contentIdToDataHandler.put(key, value);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.orphanContentIds.size() != 0) {
                result.append("Orphan Content Id : ");
                result.append(this.orphanContentIds.toString());
                result.append("\n");
            }
            if (this.orphanDataHandlers.size() != 0) {
                result.append("Orphan data handler name : [");
                for (DataHandler dtHandler : this.orphanDataHandlers) {
                    result.append(dtHandler.getName() + ",");
                }
                result.replace(result.length() - 1, result.length(), "]");
                result.append("\n");
            }
            if (this.contentIdToDataHandler.size() != 0) {
                result.append("Map associating content ID to DataHandler :");
                result.append(this.contentIdToDataHandler.toString());
            }
            return result.toString();
        }
    }
}

