/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sql;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jbi.JBIException;
import org.ow2.petals.bc.sql.DataSources;
import org.ow2.petals.bc.sql.service.SQLService;
import org.ow2.petals.bc.sql.su.SUManager;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.bc.DefaultBindingComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;

public class SqlComponent
extends DefaultBindingComponent {
    private DataSources dataSources;
    private SQLService sqlService;
    private ExecutorService threadPool;

    protected final void doInit() throws JBIException {
        this.dataSources = new DataSources(this.getLogger());
        this.sqlService = new SQLService(this.getLogger());
        this.threadPool = Executors.newCachedThreadPool();
    }

    protected final void doShutdown() throws JBIException {
        super.doShutdown();
        this.getLogger().warning("shutdown outmessage streams if any");
        List<Runnable> interruptedOutStreamerList = this.threadPool.shutdownNow();
        if (interruptedOutStreamerList.size() > 0) {
            this.getLogger().warning("some outmessage streams have been interrupted");
        }
        this.getLogger().warning("close datasources if any");
        Set<Provides> dataSourcesKeys = this.dataSources.getDataSourceKeys();
        for (Provides key : dataSourcesKeys) {
            this.getLogger().warning("Close dataSource for " + key.getServiceName() + "-" + key.getEndpointName());
            this.dataSources.closeDataSource(this.dataSources.getDataSource(key));
        }
    }

    protected AbstractServiceUnitManager createServiceUnitManager() {
        return new SUManager((AbstractComponent)this);
    }

    public SQLService getSQLService() {
        return this.sqlService;
    }

    public DataSources getDataSources() {
        return this.dataSources;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }
}

