/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import java.io.File;
import javax.jbi.messaging.FlowAttributes;
import javax.xml.namespace.QName;

public final class PetalsExecutionContext {
    private static final SimpleUUIDGenerator simpleUUIDGenerator = new SimpleUUIDGenerator();

    public static final void putDefaultProperties() {
        ExecutionContext.getProperties().setProperty("logSubdir", "");
        ExecutionContext.getProperties().setProperty("logFilename", "petals.log");
    }

    public static final void putFlowInstanceId(String flowInstanceId) {
        assert (flowInstanceId != null);
        ExecutionContext.getProperties().setProperty("flowInstanceId", flowInstanceId);
        ExecutionContext.getProperties().setProperty("logSubdir", "flow-monitoring" + File.separator + flowInstanceId);
    }

    public static final void initFlowInstanceId() {
        PetalsExecutionContext.putFlowInstanceId(simpleUUIDGenerator.getNewID());
    }

    public static final void putFlowStepId(String flowStepId) {
        assert (flowStepId != null);
        ExecutionContext.getProperties().setProperty("flowStepId", flowStepId);
    }

    public static final void putFlowAttributes(FlowAttributes flowAttributes) {
        assert (flowAttributes != null);
        PetalsExecutionContext.putFlowInstanceId(flowAttributes.getFlowInstanceId());
        PetalsExecutionContext.putFlowStepId(flowAttributes.getFlowStepId());
    }

    public static final FlowAttributes getFlowAttributes() {
        String flowInstanceId = ExecutionContext.getProperties().getProperty("flowInstanceId");
        if (flowInstanceId == null) {
            return null;
        }
        String flowStepId = ExecutionContext.getProperties().getProperty("flowStepId");
        if (flowStepId == null) {
            return null;
        }
        return new FlowAttributes(flowInstanceId, flowStepId);
    }

    public static void putPetalsFileHandlerBaseDir(String petalsFileHandlerBasedir) {
        ExecutionContext.getProperties().setProperty("petalsFileHandlerBasedir", petalsFileHandlerBasedir);
    }

    public static void nextFlowStepId() {
        if (ExecutionContext.getProperties().getProperty("flowStepId") != null) {
            ExecutionContext.getProperties().setProperty("flowPreviousStepId", ExecutionContext.getProperties().getProperty("flowStepId"));
        }
        ExecutionContext.getProperties().setProperty("flowStepId", simpleUUIDGenerator.getNewID());
    }

    public static final void putFlowStepInterfaceName(QName interfaceName) {
        assert (interfaceName != null);
        ExecutionContext.getProperties().setProperty("flowStepInterfaceName", interfaceName.toString());
    }

    public static final void putFlowStepOperationName(QName operation) {
        assert (operation != null);
        ExecutionContext.getProperties().setProperty("flowStepOperationName", operation.toString());
    }

    public static final void putFlowStepServiceName(QName serviceName) {
        assert (serviceName != null);
        ExecutionContext.getProperties().setProperty("flowStepServiceName", serviceName.toString());
    }

    public static final void putFlowStepEndpointName(String flowStepEndpointName) {
        assert (flowStepEndpointName != null);
        ExecutionContext.getProperties().setProperty("flowStepEndpointName", flowStepEndpointName);
    }
}

