/**
 * PETALS: PETALS Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */

package org.ow2.petals.component.framework.api.notification;

import javax.xml.namespace.QName;

import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;

/**
 * An asynchronous notification sender. The response are handled in a
 * {@link StatusListener} attached to the implementation.
 * 
 * @author chamerling - eBM WebSourcing
 * 
 */
public interface AsyncSender {

    /**
     * @deprecated notifications without managers
     * @use send(final DestroyRegistration destroyRegistration, final
     *      SOAParameterType soaParameterType) through the managers
     */
    @Deprecated
    void send(final DestroyRegistration destroyRegistration) throws PEtALSCDKException;

    /**
     * 
     * @param destroyRegistration
     * @param soaParameterType
     * @throws PEtALSCDKException
     */
    void send(final DestroyRegistration destroyRegistration, final SOAParameterType soaParameterType)
            throws PEtALSCDKException;

    /**
     * Send a {@link RegisterPublisher} payload to the broker.
     * 
     * @param registerPublisher
     * @throws PEtALSCDKException
     */
    void send(final RegisterPublisher registerPublisher) throws PEtALSCDKException;

    /**
     * Send a subscribe request asynchronously to the notification broker (aka
     * SE-Notif) hardcoded Subscription manager interface
     * 
     * @param subscribe
     *            a subscribe request java object
     * @throws PEtALSCDKException
     */
    void send(final Subscribe subscribe) throws PEtALSCDKException;

    /**
     * Send a subscribe request asynchronously to the provided service endpoint
     * (denoted by the given service name and endpoint name)
     * 
     * @param subscribe
     *            a subscribe request java object
     * @param servName
     *            a targeted service QName (must be not null)
     * @param epName
     *            a targeted endpoint name (must be not null and not empty)
     */
    void send(final Subscribe subscribe, final QName servName, final String epName);

    /**
     * 
     * @param unsubscribe
     * @throws PEtALSCDKException
     */
    void send(final Unsubscribe unsubscribe) throws PEtALSCDKException;

    /**
     * 
     * @param notify
     * @param consumerReference
     * @throws PEtALSCDKException
     */
    void send(final Notify notify, final EndpointReferenceType consumerReference)
            throws PEtALSCDKException;

    /**
     * Abort all the current tasks... This sender must never be reused.
     * 
     * @throws PEtALSCDKException
     */
    void abort() throws PEtALSCDKException;

    /**
     * Check if the sender as been stopped (via abort method). If true, it must
     * not be reused.
     * 
     * @return true if aborted. false otherwhise.
     */
    boolean isStopped();

}
