/**
 * PETALS: PETALS Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package org.ow2.petals.component.framework.api.notification;

import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

/**
 * This is the notification service which handle all notification related stuff.
 * 
 * @author chamerling - eBM WebSourcing
 * @since 2.0.4
 * 
 */
public interface NotificationService extends LifeCyle, StatusListener {

    /**
     * Activate or unactivate the notifications feature. If it becomes active,
     * it means that the component will register itself to the notification
     * broker and that it will be able to send and receive notifications. On the
     * other case, unregister itself so notification can not be send nd/or
     * received.
     * 
     * @throws PEtALSCDKException
     */
    void setActive(boolean status) throws PEtALSCDKException;

    /**
     * The notification broker controller
     * 
     * @return
     */
    NotificationBrokerController getNotificationBrokerController();

    /**
     * The sender which is in charge of sending things through the service bus.
     * 
     * @return
     */
    Sender getSender();

    /**
     * Add a global listener which will react on notification subscription
     * changes
     * 
     * @param listener
     */
    void addListener(StatusListener listener);

    /**
     * Get an asynchronous sender and pass it a listener to handle responses.
     * All the calls are fire and forget ones in a total asynchronous mode. A
     * new instance of the {@link AsyncSender} is returned on each call.
     * 
     * @param listener
     * @return
     */
    AsyncSender getAsyncSender(StatusListener listener);

}
