/**
 * PETALS: PETALS Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */

package org.ow2.petals.component.framework.api.notification;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;

import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;

/**
 * Notification messages sender API.
 * 
 * @author chamerling - eBM WebSourcing
 * @since 2.0.4
 * 
 */
public interface Sender {

    /**
     * Return the sender related JBI component context
     * 
     * @return the sender related JBI component context
     */
    ComponentContext getComponentContext();

    /**
     * @deprecated notifications without managers
     * @use send(final DestroyRegistration destroyRegistration, final
     *      SOAParameterType soaParameterType) through the managers
     */
    @Deprecated
    DestroyRegistrationResponse send(final DestroyRegistration destroyRegistration)
            throws MessagingException, WSNotificationException, PEtALSCDKException;

    DestroyRegistrationResponse send(final DestroyRegistration destroyRegistration,
            final SOAParameterType soaParameterType) throws MessagingException,
            WSNotificationException, PEtALSCDKException;

    /**
     * Send a {@link RegisterPublisher} payload to the broker.
     * 
     * @param registerPublisher
     * @return
     * @throws MessagingException
     * @throws WSNotificationException
     * @throws PEtALSCDKException
     */
    RegisterPublisherResponse send(final RegisterPublisher registerPublisher)
            throws MessagingException, WSNotificationException, PEtALSCDKException;

    /**
     * Send a subscribe request asynchronously to the provided service endpoint
     * (denoted by the given service name and endpoint name)
     * 
     * @param subscribe
     *            a subscribe request java object
     * @param targetServName
     *            a targeted service QName (must be not null)
     * @param targetEpName
     *            a targeted endpoint name (must be not null and not empty)
     * @return a subscribe response java object
     * @throws MessagingException
     * @throws WSNotificationException
     * @throws PEtALSCDKException
     */
    SubscribeResponse send(final Subscribe subscribe, final QName targetServName,
            final String targetEpName) throws MessagingException, WSNotificationException,
            PEtALSCDKException;

    /**
     * Send a subscribe request asynchronously to the notification broker (aka
     * SE-Notif) hardcoded Subscription manager interface
     * 
     * @param subscribe
     *            a subscribe request java object
     * @return a subscribe response java object
     * @throws MessagingException
     * @throws WSNotificationException
     * @throws PEtALSCDKException
     */
    SubscribeResponse send(final Subscribe subscribe) throws MessagingException,
            WSNotificationException, PEtALSCDKException;

    UnsubscribeResponse send(final Unsubscribe unsubscribe) throws MessagingException,
            WSNotificationException, PEtALSCDKException;

    /**
     * Send a notify on a consumerReference
     * 
     * @param notify
     *            The notify to send
     * @param consumerReference
     *            The reference to send to
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws WSNotificationException
     * @throws MessagingException
     * @throws PEtALSCDKException
     */
    void send(final Notify notify, final EndpointReferenceType consumerReference)
            throws WSAddressingException, WSNotificationExtensionException,
            WSNotificationException, MessagingException, PEtALSCDKException;

}
