/**
 * PETALS: PETALS Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package org.ow2.petals.component.framework.api.notification;

import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;

/**
 * This is a global listener for publisher and subscriber operations
 * 
 * @author chamerling - eBM WebSourcing
 * 
 */
public interface StatusListener {

    void onRegistered(RegisterPublisherResponse response) throws PEtALSCDKException;

    void onUnregistered(DestroyRegistrationResponse response) throws PEtALSCDKException;

    void onSubscribed(SubscribeResponse response) throws PEtALSCDKException;

    void onUnsubscribed(UnsubscribeResponse response) throws PEtALSCDKException;

    void onException(Exception e);

}
