/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ---------------------------------------------------------------------------
 * ---------------------------------------------------------------------------
 */
package org.ow2.petals.component.framework.api.notification;

import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;

import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;

/**
 * 
 * 
 * @author Frederic Gardes
 */
public interface Transformer {

    /**
     * Add the JBI service endpoint into the request received to the bus
     * 
     * @param normalizedMessage
     *            The in message to transform
     * @param operation
     *            The operation
     * @return the normalizedMessage with the great JBI service endpoint to
     *         invoke
     * @throws PEtALSCDKException
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws MessagingException
     */
    public NormalizedMessage transformRequestOnConsume(NormalizedMessage normalizedMessage,
            QName operation) throws PEtALSCDKException, WSNotificationException,
            WSAddressingException, MessagingException, WSNotificationExtensionException;

    /**
     * Add the JBI service endpoint into the response to the bus
     * 
     * @param subscribeResponse
     *            The subscribeResponse to transform
     * @return the subscribeResponse transformed
     * @throws PEtALSCDKException
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws MessagingException
     */
    public SubscribeResponse transformResponseOnProducer(SubscribeResponse subscribeResponse)
            throws PEtALSCDKException, WSNotificationException, WSAddressingException,
            MessagingException, WSNotificationExtensionException;

    /**
     * Remove the JBI service endpoint from the bus into the response to send
     * 
     * @param normalizedMessage
     *            The out message to transform
     * @param operation
     *            The operation
     * @return the normalizedMessage without the JBI service endpoint to invoke
     * @throws PEtALSCDKException
     * @throws WSNotificationException
     * @throws WSAddressingException
     * @throws MessagingException
     * @throws WSNotificationExtensionException
     */
    public NormalizedMessage transformResponseOnConsume(NormalizedMessage normalizedMessage,
            QName operation) throws PEtALSCDKException, WSNotificationException,
            WSAddressingException, MessagingException, WSNotificationExtensionException;

    /**
     * Set the notificationBrokerReferenceAddress
     * 
     * @param notificationBrokerReferenceAddress
     *            the notificationBrokerReferenceAddress to set
     */
    public void setNotificationBrokerReferenceAddress(String notificationBrokerReferenceAddress);

    /**
     * Set the publisherRegistrationManagerReferenceAddress
     * 
     * @param publisherRegistrationManagerReferenceAddress
     *            the publisherRegistrationManagerReferenceAddress to set
     */
    public void setPublisherRegistrationManagerReferenceAddress(
            String publisherRegistrationManagerReferenceAddress);

    /**
     * Set the subscriptionManagerReferenceAddress
     * 
     * @param subscriptionManagerReferenceAddress
     *            the subscriptionManagerReferenceAddress to set
     */
    public void setSubscriptionManagerReferenceAddress(String subscriptionManagerReferenceAddress);

    /**
     * Add the Consumer Endpoint JBI
     * 
     * @param subscribe
     *            The subscribe
     * @return The subscribe with the Consumer Endpoint JBI
     * @throws WSNotificationException
     * @throws WSAddressingException
     * @throws WSNotificationExtensionException
     * @throws MessagingException
     */
    public Subscribe addNotificationConsumerSOAParameter(Subscribe subscribe)
            throws WSNotificationException, WSNotificationExtensionException,
            WSAddressingException, MessagingException;

    /**
     * Add the Subscription Manager Endpoint JBI
     * 
     * @param notificationMessageHolderType
     *            The notification message holder of the notify
     * @return The notification message holder of the notify with the
     *         Subscription Manager Endpoint JBI
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws MessagingException
     */
    public NotificationMessageHolderType addSubscriptionManagerSOAParameter(
            NotificationMessageHolderType notificationMessageHolderType)
            throws WSNotificationException, WSAddressingException, MessagingException,
            WSNotificationExtensionException;

    /**
     * Add the Subscription Manager Endpoint JBI
     * 
     * @param subscribeResponse
     *            The subscribe response
     * @return The subscribe response with the Subscription Manager Endpoint JBI
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws MessagingException
     */
    public SubscribeResponse addSubscriptionManagerSOAParameter(SubscribeResponse subscribeResponse)
            throws WSNotificationException, WSAddressingException, MessagingException,
            WSNotificationExtensionException;

    /**
     * Add the Notification Producer Endpoint JBI
     * 
     * @param notificationMessageHolderType
     *            The notification message holder of the notify
     * @return The notification message holder of the notify with the
     *         Notification Producer Endpoint JBI
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws MessagingException
     */
    public NotificationMessageHolderType addNotificationProducerSOAParameter(
            NotificationMessageHolderType notificationMessageHolderType)
            throws WSNotificationException, WSAddressingException, MessagingException,
            WSNotificationExtensionException;

    /**
     * Add the Notification Producer Endpoint JBI
     * 
     * @param registerPublisher
     *            The Register Publisher
     * @return the registerPublisher with the Notification Producer Endpoint JBI
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws MessagingException
     */
    public RegisterPublisher addNotificationProducerSOAParameter(RegisterPublisher registerPublisher)
            throws WSNotificationException, WSAddressingException, MessagingException,
            WSNotificationExtensionException;

    /**
     * Remove the JBI service endpoint from the bus. Set the specific Consumer
     * Reference
     * 
     * @param subscribe
     *            The subscribe to transform
     * @return the subscribe transformed
     * @throws WSAddressingException
     */
    public Subscribe transformRequestOnProducer(Subscribe subscribe)
            throws WSAddressingException;

    /**
     * Remove the external address provided by the bus.
     * 
     * @param unsubscribe
     *            The unsubscribe to transform
     * @return the unsubscribe transformed
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     */
    public Unsubscribe transformRequestOnProducer(Unsubscribe unsubscribe)
            throws WSNotificationException, WSNotificationExtensionException;

    /**
     * Set the specific Producer Reference Set the specific Subscription Manager
     * Remove the external address provided by the bus.
     * 
     * @param notify
     *            The notify to transform
     * @return the notify transformed
     * @throws WSNotificationException
     * @throws WSAddressingException
     */
    public Notify transformRequestOnProducer(Notify notify) throws WSNotificationException,WSAddressingException;

}
