/**
 * PETALS - PETALS Services Platform. Copyright (c) 2009 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.component.framework.api;

import java.net.URI;

import javax.xml.namespace.QName;

/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public final class Constants {
    /**
     * Configuration constants
     */
    public static class Configuration {

    }

    /**
     * Exception constants
     */
    public static class Exception {
        /**
         * The URI to use as base URI to determine the SOAP actor.<br />
         */
        public static final URI NAMESPACE_URI = URI.create("http://petals.ow2.org");
    }

    /**
     * The Component constants
     * 
     * @author Christophe HAMERLING (chamerling) - eBM WebSourcing
     * 
     */
    public static class Component {

        public static final String JBI_XML = "jbi.xml";

        public static final String META_INF = "META-INF";

        public static final String ACKNOWLEDGEMENT_TIMEOUT = "acknowledgement-timeout";

        /**
         * The endpoint name used as the extension: auto-generated endpoint name
         * extension
         */
        public static final String AUTOGENERATED_ENDPOINT_NAME = "autogenerate";

        public static final long DEFAULT_ACKNOWLEDGEMENT_TIMEOUT = 5000L;

        public static final long DEFAULT_SEND_TIMEOUT = 30000L;

        public static final String DEFAULT_IGNORED_STATUS = "DONE_AND_ERROR_IGNORED";

        public static final int DEFAULT_POOL_SIZE = 10;

        public static final int DEFAULT_ACCEPTOR_SIZE = 5;

        public static final String MEP = "mep";

        /**
         * The name of the 'native' WSDL document managed directly by the
         * component. TODO : if needed, implement a mechanism to externalize the
         * name of the wsdl(s) into
         * {@link org.ow2.petals.component.framework.Constants.Component#JBI_XML
         * the configuration of the component}
         */
        public static final String COMPONENT_WSDL = "component.wsdl";
        
        /**
         * Name of the folder used to store native WSDL and resource.
         * This folder is a child of the WORK directory.
         */
        public static final String NATIVE_SERVICE_FOLDER = "native-service";
    }

    /**
     * WS-* constants
     */
    public static class WSStar {

        /**
         * The key of the WS-Addressing property into a JBI Exchange
         */
        public static final String ADDRESSING_KEY = "com.ebmwebsourcing.wsstar.addressing";

        /**
         * Addressing constants
         * 
         * @author chamerling - eBM WebSourcing
         * @deprecated use
         *             {@link com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory}
         *             with the key
         *             {@link org.ow2.petals.component.framework.api.WSStar.ADDRESSING_KEY}
         */
        @Deprecated
        public static class Addressing {
            /*
             * <wsa:MessageID> xs:anyURI </wsa:MessageID> <wsa:RelatesTo
             * RelationshipType="..."?>xs:anyURI</wsa:RelatesTo>
             * <wsa:To>xs:anyURI</wsa:To> <wsa:Action>xs:anyURI</wsa:Action>
             * <wsa:From>endpoint-reference</wsa:From>
             * <wsa:ReplyTo>endpoint-reference</wsa:ReplyTo>
             * <wsa:FaultTo>endpoint-reference</wsa:FaultTo>
             */
            public static final String NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";

            public static final String PREFIX = "wsa";

            public static final QName REPLY_TO_QNAME = new QName(NAMESPACE_URI, "ReplyTo", PREFIX);

            public static final QName ADDRESS_QNAME = new QName(NAMESPACE_URI, "Address", PREFIX);

            public static final QName SERVICE_NAME_QNAME = new QName(NAMESPACE_URI, "ServiceName",
                    PREFIX);

            public static final QName FROM_QNAME = new QName(NAMESPACE_URI, "From", PREFIX);

            public static final QName TO_QNAME = new QName(NAMESPACE_URI, "To", PREFIX);

            public static final QName FAULT_TO_QNAME = new QName(NAMESPACE_URI, "FaultTo", PREFIX);

            public static final QName ACTION_QNAME = new QName(NAMESPACE_URI, "Action", PREFIX);
        }

        /**
         * Topic constants TODO: use constants of wsstar
         */
        public static class Topic {
            /**
             * The namespace of the topics
             */
            public static final String NAMESPACE_URI = "http://petals.ow2.org/topic";
        }
    }
}
