/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ---------------------------------------------------------------------------
 * ---------------------------------------------------------------------------
 */
package org.ow2.petals.component.framework.api;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.w3c.dom.Document;

/**
 * Manage a wsdl. This class has two issue: <li>optimize the use of the wsdl:
 * the document for a description is generated only one time</li> <li>use
 * easywsdl on a concurrent way without problem: two writers don't use at the
 * same time the JaxB model of the description wich isn't thread safe</li>
 * 
 * @author Frederic Gardes
 */
public interface Wsdl {

    /**
     * Get the description
     * 
     * @return the description
     */
    public abstract Description getDescription();

    /**
     * Get the document
     * 
     * @return the document
     */
    public abstract Document getDocument();

}
