/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2005-2006 ObjectWeb, http://www.objectweb.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id: $
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.component.framework.api.exception;

import java.net.URI;

import javax.xml.namespace.QName;

/**
 * <p>
 * All exceptions based on this exception will be transform in a SOAP Fault
 * according to the following rules:
 * <ul>
 * <li>the fault code is set with the value returned by
 * {@link FaultException#getFaultCode()},</li>
 * <li>the fault string is set with the value returned by
 * {@link FaultException#getMessage()},</li>
 * <li>the fault actor is set with the value returned by
 * {@link FaultException#getFaultActor()},</li>
 * <li>the detail is set with the exception stack trace.</li>
 * </ul>
 * </p>
 * 
 * @author Christophe DENEUX - Capgemini Sud
 * @since 1.0
 * 
 */
public class FaultException extends Exception {

    private static final long serialVersionUID = -1605535302049019555L;

    private QName faultCode = null;
    private URI faultActor = null;

    public FaultException(final QName faultCode, final String faultString,
            final URI faultActor) {
        super(faultString);
        this.faultCode = faultCode;
        this.faultActor = faultActor;
    }
    
    public FaultException(final QName faultCode, final String faultString, final URI faultActor, final Throwable cause) {
        super(faultString, cause);
        this.faultCode = faultCode;
        this.faultActor = faultActor;
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public URI getFaultActor() {
        return this.faultActor;
    }
}
