/****************************************************************************
 *
 * Copyright (c) 2007-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.component.framework.api;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * Message constants.
 * @author Roland Naudin - EBM WebSourcing
 */
public  class Message {
    
    /**
     * The prefix of the properties to propagate during a fork of exchange
     */
    public static final String PROPAGATION_PREFIX = "org.ow2.petals.propagate";

    /**
     * The key of the process path property into a JBI Exchange
     */
    public static final String PROCESS_PATH_KEY = PROPAGATION_PREFIX + ".process";

    /**
     * The key of the correlation id property into a JBI Exchange
     */
    public static final String CORRELATION_ID_KEY = PROPAGATION_PREFIX + ".correlation";

    /**
     * The interceptor constants
     * 
     * @author Frederic Gardes - EBM WebSourcing
     * @author Christophe HAMERLING - EBM WebSourcing
     */
    public enum InterceptorPhase {
        SEND, SEND_RESPONSE, ACCEPT, ACCEPT_RESPONSE;
    }

    /**
     * Constants for the JBI Message Exchange Patterns.
     * 
     * @author ofabre
     * @author gblondelle
     */
    public enum MEPConstants {
        IN_ONLY_PATTERN("http://www.w3.org/2004/08/wsdl/in-only"), IN_OPTIONAL_OUT_PATTERN(
        "http://www.w3.org/2004/08/wsdl/in-opt-out"), IN_OUT_PATTERN(
        "http://www.w3.org/2004/08/wsdl/in-out"), ROBUST_IN_ONLY_PATTERN(
        "http://www.w3.org/2004/08/wsdl/robust-in-only");

        /**
         * 
         * @param pattern
         * @return
         */
        public static MEPConstants valueOf(final URI pattern) {
            MEPConstants result = null;
            if (pattern != null) {
                for (final MEPConstants mep : MEPConstants.values()) {
                    if (mep.nameSpace.equals(pattern.toString())) {
                        result = mep;
                    }
                }
            }
            return result;
        }

        private final String nameSpace;
        private final URI mepURI;

        /**
         * Creates a new instance of {@link MEPConstants}.
         * @param nameSpace
         */
        private MEPConstants(final String nameSpace) {
            this.nameSpace = nameSpace;
            try {
                this.mepURI = new URI(nameSpace);
            } catch (final URISyntaxException e) {
                throw new Error("Unexpected Error in JBI URI namespace syntax", e); // NOPMD
            }
        }

        /**
         * @return
         */
        public URI value() {
            return this.mepURI;
        }

        /**
         * Please use this equals method instead of using :<code>
         * value().equals(mep)
         * </code> which is
         * almost 10 times slower...
         * 
         * @param mep
         * @return
         */
        public boolean equals(final URI mep) {
            return this.toString().equals(mep.toString());
        }

        /*
         * (non-Javadoc)
         * 
         * @see java.lang.Enum#toString()
         */
        @Override
        public String toString() {
            return this.nameSpace;
        }
    }
}
