/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.component.framework.api;

import java.util.Map;
import java.util.logging.Logger;

import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;

/**
 * @author Christophe HAMERLING - EBM WebSourcing
 */
public interface PetalsComponent extends javax.jbi.component.Component, ComponentLifeCycle {

    /**
     * Returns the component delivery channel, used to send messages to petals
     * container
     * 
     * @return the delivery channel. Not null.
     */
    public DeliveryChannel getChannel();

    /**
     * The component context
     * 
     * @return the component context. Not null.
     */
    public ComponentContext getContext();

    /**
     * Returns the component logger
     * 
     * @return component logger. Not null.
     */
    public Logger getLogger();

    /**
     * Get all the interceptors
     * 
     * @return
     */
    public Map<String, Interceptor> getInterceptors();

    /**
     * Get the interceptor that have the given name.
     * 
     * @param name
     * @return null if the interceptor is not found of is there are no
     *         interceptor in the component
     */
    public Interceptor getInterceptor(final String name);
}
