/****************************************************************************
 *
 * Copyright (c) 2005-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.component.framework.api.exception;

import java.net.URI;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

/**
 * All exceptions based on this exception will be transform in a SOAP Fault.
 * <p>
 * The following rules are applied:
 * <ul>
 * <li>the fault code is set with the value returned by
 * {@link DocumentException#getFaultCode()},</li>
 * <li>the fault string is set with the value returned by
 * {@link DocumentException#getMessage()},</li>
 * <li>the fault actor is set with the value returned by
 * {@link DocumentException#getFaultActor()},</li>
 * <li>the detail is set with the exception document returned by
 * {@link DocumentException#getDocument()()}.</li>
 * </ul>
 * </p>
 * 
 * @author Christophe DENEUX - Capgemini Sud
 */
public abstract class DocumentException extends FaultException {

    /**
     * 
     */
    private static final long serialVersionUID = 7765068373575291733L;

    public DocumentException(QName faultCode, String faultString,
            final URI faultActor) {
        super(faultCode, faultString, faultActor);
    }

    public abstract Document getDocument();
}
