/****************************************************************************
 *
 * Copyright (c) 2005-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.component.framework.api.exception;

import java.net.URI;

import javax.xml.namespace.QName;

/**
 * This exception represents the fault named "Client" pre-defined in the specifications of SOAP 1.1.
 * <ul>
 * <li>the fault code is set with:
 * <code>{http://schemas.xmlsoap.org/soap/envelope/}Client</code>,</li>
 * <li>the fault string is set with the provided value,</li>
 * <li>the fault actor is set with the provided value,</li>
 * <li>the detail is set with the exception stack trace.</li>
 * </ul>
 * 
 * @author Christophe DENEUX - Capgemini Sud
 */
public class SOAP11FaultClientException extends FaultException {

    private static final long serialVersionUID = 2848365844327362116L;

    public SOAP11FaultClientException(final String faultString, final URI faultActor) {
        super(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client"), faultString,
                faultActor);
    }
    
    public SOAP11FaultClientException(final String faultString, final URI faultActor, final Throwable cause) {
        super(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client"), faultString,
                faultActor, cause);
    }
}
