/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.cli.shell.PetalsShell;
import org.ow2.petals.cli.shell.ShellException;

public class PetalsShellTest {
    private PetalsShell shell;

    @Before
    public void setUp() throws Exception {
        this.shell = new NoExitPetalsShell();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testIsComment() {
        Assert.assertTrue((boolean)this.shell.isComment("#   "));
        Assert.assertTrue((boolean)this.shell.isComment(""));
        Assert.assertTrue((boolean)this.shell.isComment("   "));
        Assert.assertTrue((boolean)this.shell.isComment("           "));
        Assert.assertTrue((boolean)this.shell.isComment("    #"));
        Assert.assertTrue((boolean)this.shell.isComment("    ## ### ## "));
        Assert.assertFalse((boolean)this.shell.isComment("joe"));
        Assert.assertFalse((boolean)this.shell.isComment("  joe# "));
        Assert.assertFalse((boolean)this.shell.isComment(".#"));
    }

    @Test
    public final void testInterpolate() {
        Assert.assertTrue((boolean)"booo".equals(this.shell.interpolate("booo")));
        Assert.assertTrue((boolean)"   space   ".equals(this.shell.interpolate("   space   ")));
        System.clearProperty("var");
        System.clearProperty("var2");
        Assert.assertTrue((boolean)"${var}".equals(this.shell.interpolate("${var}")));
        Assert.assertTrue((boolean)"${var} ${var}".equals(this.shell.interpolate("${var} ${var}")));
        Assert.assertTrue((boolean)"${var} ${var} ${var2}".equals(this.shell.interpolate("${var} ${var} ${var2}")));
        System.setProperty("var", "value");
        Assert.assertTrue((boolean)"value".equals(this.shell.interpolate("${var}")));
        Assert.assertTrue((boolean)" value ".equals(this.shell.interpolate(" ${var} ")));
        Assert.assertTrue((boolean)" value value ".equals(this.shell.interpolate(" ${var} ${var} ")));
        Assert.assertTrue((boolean)" value value ${var2} ".equals(this.shell.interpolate(" ${var} ${var} ${var2} ")));
        Assert.assertTrue((boolean)"${var}".equals(this.shell.interpolate("\\${var}")));
        Assert.assertTrue((boolean)" ${var} value \\${var} ".equals(this.shell.interpolate(" \\${var} ${var} \\\\${var} ")));
    }

    private class NoExitPetalsShell
    extends PetalsShell {
        public void exit(int status) {
        }
    }
}

