/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.jbi;

import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.ow2.petals.cli.shell.jbi.Artifact;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ArtifactTest {
    public static final URL BC_ZIP_URL = ArtifactTest.class.getResource("/jbi-component-soap.zip");
    public static final URL BC_XML_URL = ArtifactTest.class.getResource("/jbi-bc.xml");

    static Node getBcJbiXml() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(BC_XML_URL.openStream());
        doc.getDocumentElement().normalize();
        return doc.getFirstChild();
    }

    @Test
    public void testArtifact() {
        JbiArtifact a = new JbiArtifact(null, null);
        Assert.assertNull((Object)a.getURL());
        Assert.assertNull((Object)a.getJbiXml());
    }

    @Test
    public void testGetURL() {
        try {
            JbiArtifact a = new JbiArtifact(BC_ZIP_URL, null);
            Assert.assertSame((Object)BC_ZIP_URL, (Object)a.getURL());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Ignore(value="problem loading url from resource")
    @Test
    public void testGetJbiXml() {
        try {
            JbiArtifact a = new JbiArtifact(null, ArtifactTest.getBcJbiXml());
            Assert.assertSame((Object)ArtifactTest.getBcJbiXml(), (Object)a.getJbiXml());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetName() {
        try {
            JbiArtifact a = new JbiArtifact(null, ArtifactTest.getBcJbiXml());
            Assert.assertEquals((Object)"petals-bc-soap-provide", (Object)a.getName());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetDescription() {
        try {
            JbiArtifact a = new JbiArtifact(null, ArtifactTest.getBcJbiXml());
            Assert.assertEquals((Object)"petals-bc-soap-provide", (Object)a.getName());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        try {
            JbiArtifact a = new JbiArtifact(BC_ZIP_URL, ArtifactTest.getBcJbiXml());
            String s = a.toString();
            Assert.assertNotNull((Object)s);
            Assert.assertTrue((s.length() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    class JbiArtifact
    extends Artifact {
        public JbiArtifact(URL url, Node jbiConfig) {
            super(url, jbiConfig);
        }

        public AbstractJBIAntTask[] getDeployTasksSequence() {
            return null;
        }

        public AbstractJBIAntTask[] getUndeployTasksSequence() {
            return null;
        }
    }
}

