/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli;

import java.io.File;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.ow2.petals.cli.shell.PetalsShell;
import org.ow2.petals.cli.shell.PetalsShellConsole;
import org.ow2.petals.cli.shell.Shell;

public class Main {
    private static final String JAR_PATH = Main.class.getProtectionDomain().getCodeSource().getLocation().getFile();
    public static final String FULL_NAME = "Petals JMX Command Line Interface";
    public static final String[][] DEFAULT_PROPERTIES = new String[][]{{"petals.user", "petals"}, {"petals.password", "petals"}, {"petals.host", "localhost"}, {"petals.port", "7700"}};

    private static void printVersion() {
        StringBuffer sb = new StringBuffer();
        sb.append(FULL_NAME).append(' ');
        sb.append(Main.class.getPackage().getImplementationVersion()).append('\n');
        sb.append(System.getProperty("java.runtime.name")).append(' ');
        sb.append(System.getProperty("java.runtime.version")).append('\n');
        sb.append(System.getProperty("os.name")).append(' ');
        sb.append(System.getProperty("os.version")).append('\n');
        System.out.print(sb.toString());
    }

    private static void printUsage(Options options) {
        String usage = "java -jar " + new File(JAR_PATH).getName() + " [OPTIONS] [COMMAND [ARGS...]]";
        System.out.println(FULL_NAME);
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(usage, options);
        System.out.println();
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption("H", "help", false, "Print this help message and exit");
        options.addOption("V", "version", false, "Print the version number and exit");
        options.addOption("d", "debug", false, "Print stack trace and debugging informations");
        options.addOption("s", "script", false, "Read commands from standard input");
        options.addOption("h", "host", true, "remote petals ESB host name");
        options.addOption("n", "port", true, "port number");
        options.addOption("u", "user", true, "username");
        options.addOption("p", "password", true, "password");
        return options;
    }

    public static void runPetalsScript(Shell shell, String[] argv) throws Exception {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(System.in));
        for (int i = 0; i < argv.length; ++i) {
            System.setProperty("argv_" + i, argv[i]);
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                shell.evaluate(line);
            }
        }
        catch (Exception e) {
            String msg = "line " + reader.getLineNumber() + ": " + e.getMessage();
            throw new Exception(msg, e);
        }
    }

    private static void initProperties() {
        for (String[] a : DEFAULT_PROPERTIES) {
            assert (a != null && a.length == 2);
            if (System.getProperty(a[0]) != null) continue;
            System.setProperty(a[0], a[1]);
        }
    }

    public static void main(String[] args) {
        CommandLine cmd = null;
        Main.initProperties();
        try {
            Options options = Main.createOptions();
            PosixParser parser = new PosixParser();
            cmd = parser.parse(options, args);
            if (cmd.hasOption('V')) {
                Main.printVersion();
            } else if (cmd.hasOption('H')) {
                Main.printUsage(options);
            } else {
                if (cmd.hasOption('u')) {
                    System.setProperty("petals.user", cmd.getOptionValue('u'));
                }
                if (cmd.hasOption('p')) {
                    System.setProperty("petals.password", cmd.getOptionValue('p'));
                }
                if (cmd.hasOption('h')) {
                    System.setProperty("petals.host", cmd.getOptionValue('h'));
                }
                if (cmd.hasOption('n')) {
                    System.setProperty("petals.port", cmd.getOptionValue('n'));
                }
                if (cmd.hasOption('s')) {
                    Main.runPetalsScript(new PetalsShell(), cmd.getArgs());
                } else if (cmd.getArgList().isEmpty()) {
                    new PetalsShellConsole();
                } else {
                    new PetalsShell(cmd.getArgs());
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            if (cmd != null && cmd.hasOption('d')) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

