/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.CommandException;
import org.ow2.petals.cli.shell.command.utils.AntUtils;
import org.ow2.petals.cli.shell.jbi.Artifact;
import org.ow2.petals.cli.shell.jbi.ArtifactFactory;

public class Deploy
extends Command {
    public Deploy(Shell shell) {
        super(shell);
        this.setUsage("<url>");
        this.setDescription("Deploy and start a JBI artifact in petals container");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        this.checkArguments(args, 1);
        try {
            String arg = args[0];
            URL url = new URL(StringUtils.contains((String)arg, (String)"://") ? arg : "file://" + arg);
            Artifact artifact = ArtifactFactory.newInstance(url);
            for (AbstractJBIAntTask task : artifact.getDeployTasksSequence()) {
                AntUtils.configureJBIAntTask(task);
                task.doTask();
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

