/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.ow2.petals.ant.task.ShutdownAllComponentsTask;
import org.ow2.petals.ant.task.ShutdownAllServiceAssembliesTask;
import org.ow2.petals.ant.task.StopAllComponentsTask;
import org.ow2.petals.ant.task.StopAllServiceAssembliesTask;
import org.ow2.petals.ant.task.UndeployAllServiceAssembliesTask;
import org.ow2.petals.ant.task.UninstallAllSharedLibrariesTask;
import org.ow2.petals.ant.task.UninstallComponentsTask;
import org.ow2.petals.ant.task.UnloadAllInstallersTask;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.CommandException;
import org.ow2.petals.cli.shell.command.utils.AntUtils;
import org.ow2.petals.cli.shell.jbi.Artifact;
import org.ow2.petals.cli.shell.jbi.ArtifactFactory;

public class Undeploy
extends Command {
    public Undeploy(Shell shell) {
        super(shell);
        this.setUsage("url...");
        this.setDescription("Stop and uninstall or undeploy JBI artifacts");
    }

    private void undeployAllArtifacts() throws Exception {
        AbstractJBIAntTask[] tasks = new AbstractJBIAntTask[]{new StopAllServiceAssembliesTask(), new ShutdownAllServiceAssembliesTask(), new UndeployAllServiceAssembliesTask(), new StopAllComponentsTask(), new ShutdownAllComponentsTask(), new UninstallComponentsTask(), new UninstallAllSharedLibrariesTask(), new UnloadAllInstallersTask()};
        this.getShell().out.println("Undeploy all JBI artifacts");
        for (AbstractJBIAntTask task : tasks) {
            AntUtils.configureJBIAntTask(task);
            task.doTask();
        }
    }

    private void undeployArtifact(URL url) throws Exception {
        this.getShell().out.println("Undeploy JBI artifact " + url + " ...");
        Artifact artifact = ArtifactFactory.newInstance(url);
        for (AbstractJBIAntTask task : artifact.getUndeployTasksSequence()) {
            AntUtils.configureJBIAntTask(task);
            task.doTask();
        }
    }

    @Override
    public void execute(String[] args) throws CommandException {
        try {
            if (args.length == 0) {
                this.undeployAllArtifacts();
            } else {
                for (String arg : args) {
                    URL url = new URL(StringUtils.contains((String)arg, (String)"://") ? arg : "file://" + arg);
                    this.undeployArtifact(url);
                }
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

