/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.jbi;

import java.net.URL;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.ow2.petals.ant.task.DeployServiceAssemblyTask;
import org.ow2.petals.ant.task.ShutdownServiceAssemblyTask;
import org.ow2.petals.ant.task.StartServiceAssemblyTask;
import org.ow2.petals.ant.task.StopServiceAssemblyTask;
import org.ow2.petals.ant.task.UndeployServiceAssemblyTask;
import org.ow2.petals.cli.shell.jbi.Artifact;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceAssembly
extends Artifact {
    public static final String XPATH_JBI_SU_NAMES = "/*[local-name()='jbi']/*[local-name()='service-assembly']/*[local-name()='service-unit']/*[local-name()='identification']/*[local-name()='name']";
    public static final String XPATH_JBI_SU_COMPONENTS = "/*[local-name()='jbi']/*[local-name()='service-assembly']/*[local-name()='service-unit']/*[local-name()='target']/*[local-name()='component-name']";

    public ServiceAssembly(URL url, Node jbiConfig) {
        super(url, jbiConfig);
    }

    public String[] getServiceUnits() {
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            NodeList list = (NodeList)xp.evaluate(XPATH_JBI_SU_NAMES, this.getJbiXml(), XPathConstants.NODESET);
            String[] result = new String[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                result[i] = list.item(i).getTextContent();
            }
            return result;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("XPATH_JBI_SU_NAMES", e);
        }
    }

    public String[] getDependencies() {
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            NodeList list = (NodeList)xp.evaluate(XPATH_JBI_SU_COMPONENTS, this.getJbiXml(), XPathConstants.NODESET);
            String[] result = new String[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                result[i] = list.item(i).getTextContent();
            }
            return result;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("XPATH_JBI_SU_COMPONENTS", e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        String prefix = "               ";
        sb.append("Service Units:\n");
        for (String name : this.getServiceUnits()) {
            sb.append("               ").append(name).append('\n');
        }
        sb.append("Dependencies:\n");
        for (String name : this.getDependencies()) {
            sb.append("               ").append(name).append('\n');
        }
        return sb.toString();
    }

    @Override
    public AbstractJBIAntTask[] getDeployTasksSequence() {
        DeployServiceAssemblyTask install = new DeployServiceAssemblyTask();
        StartServiceAssemblyTask start = new StartServiceAssemblyTask();
        install.setFile(this.getURL().toString());
        start.setName(this.getName());
        return new AbstractJBIAntTask[]{install, start};
    }

    @Override
    public AbstractJBIAntTask[] getUndeployTasksSequence() {
        StopServiceAssemblyTask stop = new StopServiceAssemblyTask();
        ShutdownServiceAssemblyTask shutdown = new ShutdownServiceAssemblyTask();
        UndeployServiceAssemblyTask undeploy = new UndeployServiceAssemblyTask();
        undeploy.setName(this.getName());
        stop.setName(this.getName());
        shutdown.setName(this.getName());
        return new AbstractJBIAntTask[]{stop, shutdown, undeploy};
    }
}

